package com.testor.module.messageNotice.service;


import com.testor.module.messageNotice.model.domain.TMsgNotice;
import com.testor.module.messageNotice.model.vo.MsgTemplateVO;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 消息通知Service接口
 * 
 * @author testor-framework
 * @date 2022-05-18 19:38:47
 */
public interface TMsgNoticeService extends SuperService<TMsgNotice> {
    /**
     * 审批流程通过后的消息通知处理
     */
    void processPassMsgHandle(String startUserId, String businessKey, Map variablesMap);

    /**
     * 获取 需要发送消息的 用户
     *
     * @param tableName 业务表
     * @param bizKeyId  业务id
     * @return
     */
    List<String> obtainMsgUsers(String tableName, String bizKeyId);

    /**
     * 组装消息通知
     *
     * @param bizKey
     * @param bizKeyId
     * @param userIdList
     * @param msgTemplate
     * @return
     */
    List<TMsgNotice> generateMsgNotice(String bizKey, String bizKeyId, List<String> userIdList, MsgTemplateVO msgTemplate);

    /**
     * 解析消息模板
     *
     * @param msgTemplate
     * @param variablesMap
     * @return
     */
    String analysisMsgTemplate(String msgTemplate, Map<String, String> variablesMap);

    /**
     * 标记为已读
     * @param msgNoticeId
     */
    boolean read(String msgNoticeId);

    /**
     * 标记为已读
     * @param businessKey 模块类型
     * @param businessId  业务id
     */
    boolean read(String businessKey, String businessId);

    /**
     * 批量标记为已读
     * @param msgNoticeIds
     */
    boolean readByArr(String msgNoticeIds);

    /**
     * 批量标记为已读
     */
    boolean readByArr(String businessKey, String businessIds);

    /**
     * 统计用户 每个流程定义中 未读的个数
     */
    List<Map> countUnRead(@Param("userId") String userId);
}
