package com.testor.module.partner.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.module.partner.model.domain.TPartnerOrg;
import com.testor.module.partner.model.dto.TPartnerOrgDTO;
import com.testor.module.partner.model.dto.TPartnerOrgParam;
import com.testor.module.partner.model.excel.PartnerExp;
import com.testor.module.partner.model.excel.PartnerReport;
import com.testor.module.partner.model.vo.PartnerOrgBlacklistVO;
import com.testor.module.partner.model.vo.PartnerOrgDetailVO;
import com.testor.module.partner.model.vo.PartnerOrgVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * 相关方组织机构Service接口
 *
 * @author testor-framework
 * @date 2022-06-01 14:16:53
 */
public interface TPartnerOrgService extends SuperService<TPartnerOrg> {
    /**
     * 编辑相关方机构
     *
     * @param partnerOrg
     * @return
     */
    BaseResponse<TPartnerOrg> editPartnerOrg(TPartnerOrgDTO partnerOrg);

    /**
     * 检测当前用户是否有删除权限
     *
     * @param deleteType 删除类型：1-相关方机构删除； 2-黑名单相关方机构删除
     * @return false-检测不通过   true-检测通过
     */
    boolean checkDeleteAuthority(Integer deleteType);

    /**
     * 获取 导出相关方组织机构的 数据源
     *
     * @param dsName
     * @param datasetName
     * @param parameters
     * @return
     */
    List<PartnerReport> exportPartnerOrg(String dsName, String datasetName, Map<String, Object> parameters);


    /**
     * 导入 相关方机构
     *
     * @param file
     */
    BaseResponse<String> importPartnerOrg(MultipartFile file);

    void handleExcelData(List<PartnerExp> partnerExpList);

    IPage<PartnerOrgVO> listByPage(TPartnerOrgParam param);

    /**
     * 获取相关方详情信息
     *
     * @param resId 相关方与责任方绑定id
     * @return PartnerOrgDetailVO
     */
    PartnerOrgDetailVO getDetail(String resId);

    /**
     * 黑名单列表
     *
     * @param param .
     * @return list
     */
    IPage<PartnerOrgBlacklistVO> blacklist(TPartnerOrgParam param);

    /**
     * 获取resId和名字
     *
     * @param tPartnerOrgDTO t伙伴org dto
     * @return {@link List}<{@link TPartnerOrg}>
     */
    List<TPartnerOrg> getResid(TPartnerOrgDTO tPartnerOrgDTO);

    /**
     * orgId获取pId和名字
     *
     * @param tPartnerOrgDTO t伙伴org dto
     * @return {@link List}<{@link TPartnerOrg}>
     */
    List<TPartnerOrg> getOrgId(TPartnerOrgDTO tPartnerOrgDTO);
}
