package com.testor.module.partner.service.impl;

import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.common.util.DateUtil;
import com.testor.module.duty.util.PoiExcelUtils;
import com.testor.module.partner.dao.TJobAccountingDao;
import com.testor.module.partner.model.domain.TJobAccounting;
import com.testor.module.partner.model.dto.TJobAccountingDTO;
import com.testor.module.partner.model.vo.TJobAccountingStatisticsVO;
import com.testor.module.partner.model.vo.TJobAccountingVO;
import com.testor.module.partner.service.TJobAccountingService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 现场作业_作业统计分析Service业务层处理
 *
 * @author testor-framework
 * @date 2022-07-07 14:35:54
 */
@Service
public class TJobAccountingServiceImpl extends SuperServiceImpl<TJobAccountingDao, TJobAccounting> implements TJobAccountingService {
    @Autowired(required = false)
    private TJobAccountingDao tJobAccountingDao;

    @Autowired
    private SysOrgService sysOrgService;


    @Override
    public BaseResponse<TJobAccountingVO> getAttTypeCount(TJobAccountingDTO tJobAccountingDTO) {

        BaseResponse<TJobAccountingVO> baseResponse = new BaseResponse<>();

        UserInfo curUser = ContextUtils.getLoginUser();

        TJobAccountingVO tJobAccountingVO = new TJobAccountingVO();
        // 区域公司
        String areaOrgId = tJobAccountingDTO.getAreaOrgId();

        // 基层单位
        String grassrootsOrgId = tJobAccountingDTO.getGrassrootsOrgId();

        // 数据类型 0-全部；1-本单位；2-租赁单位
        String dateType = tJobAccountingDTO.getDateType();

        // 开始时间
        Date startDate = tJobAccountingDTO.getStartDate();

        // 结束时间
        Date endDate = tJobAccountingDTO.getEndDate();

        List<SysOrg> childrenById = sysOrgService.getChildrenById(curUser.getOrgId());


        // 危险作业次数
        List<TJobAccountingStatisticsVO> dangerousTimes = tJobAccountingDao.dangerousTimes();
        // 各类危险作业分布
        List<TJobAccountingStatisticsVO> dangerousDistributed = tJobAccountingDao.dangerousDistributed();
        // 外来作业相关方人次统计
        List<TJobAccountingStatisticsVO> partnerPeopleNum = tJobAccountingDao.partnerPeopleNum();


        tJobAccountingVO.setDangerousTimes(dangerousTimes);
        tJobAccountingVO.setDangerousDistributed(dangerousDistributed);
        tJobAccountingVO.setPartnerPeopleNum(partnerPeopleNum);

        baseResponse.setData(tJobAccountingVO);
        return baseResponse;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public BaseResponse<String> importAccounting(MultipartFile file) {
        BaseResponse<String> baseResponse = new BaseResponse<>();

        List<Map<Integer, Object>> dataList;

        UserInfo loginUser = ContextUtils.getLoginUser();

        try {
            InputStream inputStream = file.getInputStream();
            inputStream = file.getInputStream();
            // 读取Excel⽂件⼯作表
            Workbook workbook = PoiExcelUtils.readFile(inputStream, file.getOriginalFilename());
            //取得第⼀个⼯作表
            Sheet sheet = workbook.getSheetAt(0);
            //报表上传的没条数据
            dataList = PoiExcelUtils.getBody(sheet, 7, 1);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        List<TJobAccounting> accountingList = new ArrayList<>();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        for (Map<Integer, Object> map : dataList) {
            TJobAccounting tJobAccounting = new TJobAccounting();
            tJobAccounting.setOrgId(loginUser.getOrgId());
            tJobAccounting.setOrgName(String.valueOf(map.get(1)));
            tJobAccounting.setLease(String.valueOf(map.get(2)));
            tJobAccounting.setLeaseName(String.valueOf(map.get(3)));
            tJobAccounting.setAccType(String.valueOf(map.get(4)));
            tJobAccounting.setAccStartDate(DateUtil.localDateTimeToDate( LocalDateTime.parse(String.valueOf(map.get(5)), df)));
            tJobAccounting.setPartnerPopulation(Integer.valueOf(String.valueOf(map.get(6))));
            accountingList.add(tJobAccounting);
        }

        boolean saveBatch = saveBatch(accountingList);
        if (saveBatch) {
            return baseResponse;
        } else {
            throw new RuntimeException("新增失败");
        }

    }
}
