package com.testor.module.safe.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.common.constant.StatusEnum;
import com.testor.module.safe.dao.TSafeHazardOptionDao;
import com.testor.module.safe.model.domain.TSafeHazardOption;
import com.testor.module.safe.model.vo.TSafeHazardOptionVO;
import com.testor.module.safe.service.TSafeHazardOptionService;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 隐患巡检排查标准细则Service业务层处理
 *
 * @author testor-framework
 * @date 2022-07-27 14:48:44
 */
@Service
public class TSafeHazardOptionServiceImpl extends SuperServiceImpl<TSafeHazardOptionDao, TSafeHazardOption> implements TSafeHazardOptionService {
    @Autowired(required = false)
    private TSafeHazardOptionDao tSafeHazardOptionDao;


    @Override
    public List<TSafeHazardOptionVO> getCheckContent(String id) {


        List<TSafeHazardOption> optionsList = optionsList(id);
        List<TSafeHazardOptionVO> tSafeHazardOptionVOS = BeanHelper.listToList(optionsList, TSafeHazardOptionVO.class);

        QueryWrapper<TSafeHazardOption> queryWrapper = new QueryWrapper<>();
        for (TSafeHazardOptionVO tSafeHazardOptionVO : tSafeHazardOptionVOS) {
            String levelTowId = tSafeHazardOptionVO.getId();
            queryWrapper.clear();
            queryWrapper.eq("parent_id", levelTowId);
            queryWrapper.eq("status", StatusEnum.USE.getCode());
            queryWrapper.eq("check_type", "2");
            List<TSafeHazardOption> tSafeHazardOptionsTow = list(queryWrapper);
            List<TSafeHazardOptionVO> tSafeHazardOptionVOSTow = BeanHelper.listToList(tSafeHazardOptionsTow, TSafeHazardOptionVO.class);

            tSafeHazardOptionVO.setTSafeHazardOptionEditDTOList(tSafeHazardOptionVOSTow);

        }

        return tSafeHazardOptionVOS;
    }

    private List<TSafeHazardOption> optionsList(String id){
        QueryWrapper<TSafeHazardOption> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("parent_id", id);
        queryWrapper.eq("status", StatusEnum.USE.getCode());
        queryWrapper.eq("check_type", "1");
        return list(queryWrapper);
    }

    @Override
    public List<TSafeHazardOptionVO> getRulesList(String id) {
        List<TSafeHazardOptionVO> resultList = new ArrayList<>();
        List<TSafeHazardOptionVO> byParentIdList = getCheckContent(id);
        for (TSafeHazardOptionVO tSafeHazardOptionVO : byParentIdList) {
            List<TSafeHazardOptionVO> tSafeHazardOptionEditDTOList = tSafeHazardOptionVO.getTSafeHazardOptionEditDTOList();
            resultList.addAll(tSafeHazardOptionEditDTOList);
        }
        return resultList;
    }
}
