package com.testor.module.safeCheck.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 安全检查任务流程记录对象 t_safe_check_task_record
 * 
 * @author testor-framework
 * @date 2024-09-05 09:25:46
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_check_task_record")
@ApiModel(value = "TSafeCheckTaskRecord对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeCheckTaskRecord extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 任务id
 */
  @ApiModelProperty(value = "任务id")

  @TableField("task_id")
  private String taskId;
/**
 * 执行流程id
 */
  @ApiModelProperty(value = "执行流程id")

  @TableField("process_id")
  private String processId;
/**
 * 执行流程状态 
 */
  @ApiModelProperty(value = "执行流程状态 ")

  @TableField("process_status")
  private String processStatus;
/**
 * t_safe_chek_person表关联id
 */
  @ApiModelProperty(value = "t_safe_chek_person表关联id")

  @TableField("check_person_id")
  private String checkPersonId;
/**
 * 关联id
 */
  @ApiModelProperty(value = "关联id")

  @TableField("ref_id")
  private String refId;

  /**
   * 检查人员id
   */
  @ApiModelProperty(value = "关联类型 1用户 2隐患台账")

  @TableField("ref_type")
  private String refType;

/**
 * 计划id
 */
  @ApiModelProperty(value = "计划id")

  @TableField("plan_id")
  private String planId;

  /**
   * 计划id
   */
  @ApiModelProperty(value = "任务完成时间")

  @TableField("complete_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date completeTime;

  /**
   * 计划id
   */
  @ApiModelProperty(value = "是否逾期 0否 1是")

  @TableField("is_overdue")
  private String isOverdue;

  /**
   * 排查机构id
   */
  @ApiModelProperty(value = "排查机构id")

  @TableField("org_id")
  private String orgId;

  @TableField(exist = false)
  private String name;

  public static final String ID ="id";
  public static final String TASK_ID ="task_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String CHECK_PERSON_ID ="check_person_id";
  public static final String USER_ID ="user_id";
  public static final String PLAN_ID ="plan_id";


  public enum RefType {
    USER("1", "用户"),
    HIDDEN_TROUBLE("2", "隐患台账");

    private final String code;
    private final String name;

    RefType(String code, String name) {
      this.code = code;
      this.name = name;
    }

    public String getCode() {
      return code;
    }

    public String getName() {
      return name;
    }
  }

}
