package com.testor.module.safeCheck.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckPlan;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 巡检计划 删除参数对象
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:52
 */

@Data
@ApiModel(value = "TSafeHazardCheckPlan 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TSafeHazardCheckPlanParam extends TSafeHazardCheckPlan {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "计划开始时间-起始时间")
	private Date startDateStart;

	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "计划开始时间-截止时间")
	private Date startDateEnd;

	@ApiModelProperty(value = "排查对象-类型(1-设备；2-空间；3-自定义)")
	private String checkObjectType;

	@ApiModelProperty(value = "对象分类id")
	private String checkObjectTypeId;

	@ApiModelProperty(value = "排查对象id")
	private String checkObjectId;

	@ApiModelProperty(value = "计划状态(0-未开始；1-进行中；2-已结束)")
	private Integer planStatus;

	@ApiModelProperty(value = "巡查标准id")
	private String standardId;

	@ApiModelProperty(value = "企业选择")
	private List<String> condOrgIdList;

}
