package com.testor.module.safeCheck.service;


import com.testor.module.safeCheck.model.domain.TSafeHazardCheckTask;
import com.testor.module.safeCheck.model.dto.TSafeHazardCheckTaskParam;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckTaskListVO;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckTaskVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

/**
 * 巡检任务Service接口
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:59
 */
public interface TSafeHazardCheckTaskService extends SuperService<TSafeHazardCheckTask> {

    TSafeHazardCheckTask generateCheckTask(String checkPeopleId);

    /**
     * 分页查询
     * @param param
     * @return
     */
    BaseResponseList<SafeHazardCheckTaskListVO> listPage(TSafeHazardCheckTaskParam param);

    /**
     * 巡检排查任务状态更改任务: 未开始 -> 进行中
     */
    Boolean changeCheckTaskStatus(String checkTaskId);

    SafeHazardCheckTaskVO findById(String taskId);

    /**
     * 提交 完成任务
     * @param checkTaskId  巡检任务id
     * @param taskId     审批流程任务id
     * @return
     */
    BaseResponse completeTask(String checkTaskId, String taskId);
}
