package com.testor.module.sys.service;

import com.testor.biz.sys.dict.data.model.domain.SysDictData;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataResponse;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public interface NewSysDictDataService {

    /**
     * 获取字典类型数据详情
     * @param dictDataId 字典值id
     * @param dictType 字典类型
     * @param dictKey 字典key
     * @return
     */
    SysDictData getDictTypeDetail(String dictDataId, String dictType, String dictKey);

    /**
     *  获取字典类型数据
     * @param dictType 字典类型
     * @return
     */
    List<SysDictData> getDictByType(String dictType);

    /**
     * 根据字典类型和字典标签获取字典值Id
     *
     * @param type  字典类型
     * @param dictValue 字典值
     * @param separator 分隔符
     * @return 字典id
     */
    String getDictId(String type, String dictValue, String separator);

    /**
     * 根据字典类型和字典Key获取字典值Id
     *
     * @param dictType  字典类型
     * @param dictKey 字典值
     * @return 字典id
     */
    String getDictIdByKey(String dictType, String dictKey);

    /**
     *
     * @param id 字典id
     * @param separator 分隔符
     * @return 字典值
     */
    String getDictValue(String id, String separator);

    /**
     * 根据字典id获取value 格式为 父级value/子级value
     * @param id 子级字典id
     * @param separator 分隔符
     * @return 字典值
     */
    String getDictDetailedValue(String id, String separator);


    /**
     * 根据字典父级id和字典值获取字典数据
     * @param parentId
     * @param value
     * @return
     */
    SysDictData getDictByParentIdAndValue(String parentId,String value);

    /**
     * 根据字典类型和字典值获取字典数据
     * @param type
     * @param value
     * @return
     */
    SysDictData getDictByTypeAndValue(String type,String value);

    /**
     * 根据字典父级id和字典类型获取字典id集合
     * @param parentKey 父级key
     * @param type 字典类型
     * @return
     */
    List<String> getDictIdsByParentKeyAndType(String parentKey, String type);

    /**
     * 根据字典id获取字典数据
     * @param dictDataId 字典id
     * @return
     */
    SysDictData getDictDataById(String dictDataId);
}
