package com.testor.module.train.course.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 课程章节—安全培训教育对象 t_train_section
 * 
 * @author testor-framework
 * @date 2022-07-25 18:03:44
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_section")
@ApiModel(value = "TTrainSection对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainSection extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 课程ID
 */
  @ApiModelProperty(value = "课程ID")

  @TableField("course_id")
  private String courseId;
/**
 * 父级ID
 */
  @ApiModelProperty(value = "父级ID")

  @TableField("parent_id")
  private String parentId;
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 章节名称
 */
  @ApiModelProperty(value = "章节名称")

  @TableField("section_name")
  private String sectionName;
/**
 * 第几章节
 */
  @ApiModelProperty(value = "第几章节")

  @TableField("several_section")
  private String severalSection;

  public static final String ID ="id";
  public static final String COURSE_ID ="course_id";
  public static final String PARENT_ID ="parent_id";
  public static final String TENANT_ID ="tenant_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String SECTION_NAME ="section_name";
  public static final String SEVERAL_SECTION ="several_section";


}
