package com.testor.module.train.project.model.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 用户专业评分表
 * </p>
 *
 * @author caoqiang
 * @since 2024-09-07
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("t_professional_indicator_score")
public class ProfessionalIndicatorScore implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private String id;

    /**
     * 用户id
     */
    @TableField(value = "user_id")
    private String userId;

    /**
     * 总分
     */
    @TableField(value = "total_score")
    private String totalScore;

    /**
     * 总分描述 专业指数得分在6分以下为不达标，6-8分为达标，8分以上为优秀
     */
    @TableField(value = "total_score_des")
    private String totalScoreDes;


    /**
     * 学历
     */
    @TableField("education")
    private String education;

    @TableField("education_score")
    private String educationScore;

    /**
     * 专业指标
     */
    @TableField("speciality")
    private String speciality;

    @TableField("speciality_score")
    private String specialityScore;

    @TableField("education_speciality_file_ids")
    private String educationSpecialityFileIds;

    /**
     * 工作经验
     */
    @TableField("work_experience")
    private String workExperience;

    @TableField("work_experience_score")
    private String workExperienceScore;

    @TableField("work_experience_file_ids")
    private String workExperienceFileIds;

    /**
     * 专业资格 字典值 aptitude_type
     */
    @TableField("person_aptitude_ids")
    private String personAptitudeIds;

    @TableField("person_aptitude_score")
    private String personAptitudeScore;


    /**
     * 工作成果
     */
    @TableField("work_product")
    private String workProduct;

    @TableField("work_product_file_ids")
    private String workProductFileIds;

    @TableField("work_product_score")
    private String workProductScore;


    /**
     * 奖励情况
     */
    @TableField("honors")
    private String honors;

    @TableField("honors_score")
    private String honorsScore;

    @TableField("honors_file_ids")
    @ApiModelProperty(value = "奖励情况文件id 逗号分隔")
    private String honorsFileIds;


    /**
     * 状态：0正常 1删除 2停用
     */
    @TableField("status")
    private String status;

    /**
     * 创建者
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建时间
     */
    @TableField("create_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    /**
     * 最后一次更新者
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 最后一次更新时间
     */
    @TableField("update_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;

    /**
     * 备注
     */
    @TableField("remarks")
    private String remarks;


    public static final String ID = "id";

    public static final String USER_ID = "user_id";

    public static final String TOTAL_SCORE = "total_score";

    public static final String EDUCATION = "education";

    public static final String EDUCATION_SCORE = "education_score";

    public static final String SPECIALITY = "speciality";

    public static final String SPECIALITY_SCORE = "speciality_score";

    public static final String EDUCATION_SPECIALITY_FILE_IDS = "education_speciality_file_ids";

    public static final String WORK_EXPERIENCE = "work_experience";

    public static final String WORK_EXPERIENCE_SCORE = "work_experience_score";

    public static final String WORK_EXPERIENCE_FILE_IDS = "work_experience_file_ids";

    public static final String PROFESSIONAL_QUALIFICATIONS = "professional_qualifications";

    public static final String PROFESSIONAL_QUALIFICATIONS_SCORE = "professional_qualifications_score";

    public static final String WORK_PRODUCT = "work_product";

    public static final String WORK_PRODUCT_SCORE = "work_product_score";

    public static final String HONORS = "honors";

    public static final String HONORS_SCORE = "honors_score";

    public static final String STATUS = "status";

    public static final String CREATE_BY = "create_by";

    public static final String CREATE_DATE = "create_date";

    public static final String UPDATE_BY = "update_by";

    public static final String UPDATE_DATE = "update_date";

    public static final String REMARKS = "remarks";

}
