/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.workflow.service.impl;

import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.workflow.service.TfwProcessInsService;
import com.tongtech.tfw.workflow.service.dto.ProcessInsStartParams;
import com.tongtech.tfw.workflow.service.dto.ProcessInsStartResult;
import org.flowable.engine.IdentityService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TfwProcessInsServiceImpl
implements TfwProcessInsService {
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private RepositoryService repositoryService;

    @Override
    public ProcessInsStartResult startProcessInsByKey(ProcessInsStartParams processInsStartParams) {
        if (ObjectHelper.isEmpty((Object)processInsStartParams) || processInsStartParams.checkMiss()) {
            return ProcessInsStartResult.builder().result("\u542f\u52a8\u5931\u8d25,\u7f3a\u5c11\u542f\u52a8\u53c2\u6570").code(ProcessInsStartParams.check(processInsStartParams)).build();
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processInsStartParams.getProcessDefinitionKey()).latestVersion().singleResult();
        if (ObjectHelper.isEmpty((Object)processDefinition)) {
            return ProcessInsStartResult.builder().result("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230").code(processInsStartParams.getProcessDefinitionKey()).build();
        }
        if (processDefinition.isSuspended()) {
            return ProcessInsStartResult.builder().result("\u6d41\u7a0b\u5b9a\u4e49\u5df2\u6302\u8d77").code(processInsStartParams.getProcessDefinitionKey()).build();
        }
        this.identityService.setAuthenticatedUserId(processInsStartParams.getUserId());
        processInsStartParams.getVariables().put("executor", processInsStartParams.getUserId());
        processInsStartParams.getVariables().put("executorOrgId", processInsStartParams.getOrgId());
        processInsStartParams.getVariables().put("bizKeyId", processInsStartParams.getBizKey());
        ProcessInstance processInstance = this.runtimeService.createProcessInstanceBuilder().processDefinitionId(processDefinition.getId()).name(processInsStartParams.getBizKey()).businessKey(processInsStartParams.getBizKey()).transientVariables(processInsStartParams.getVariables()).start();
        this.runtimeService.setVariablesLocal(processInstance.getId(), processInsStartParams.getVariables());
        this.identityService.setAuthenticatedUserId(null);
        return ProcessInsStartResult.builder().result("\u542f\u52a8\u6210\u529f").code(processInstance.getId()).build();
    }
}

