package com.testor.ddd.safetyControl.interfaces.controller;

import cn.hutool.core.util.StrUtil;
import com.testor.common.core.utils.StringUtils;
import com.testor.common.util.FileUtil;
import com.testor.ddd.safetyControl.application.service.riskSourceManage.RiskSourceManageService;
import com.testor.ddd.safetyControl.application.service.riskSourceManage.RiskSourceRecordManageService;
import com.testor.ddd.safetyControl.infrastructure.uitls.RiskTemplate.DownloadRiskTemplateUtil;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceDelParam;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskSource.TSafeRiskSourceRecordDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskSource.TSafeRiskSourceRecordVO;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskSource.TSafeRiskSourceVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 危险源Controller
 *
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Validated
@RestController
@RequestMapping("/risk/source")
@Api(value = "TSafeRiskSource", tags = "危险源")
@Slf4j
public class TSafeRiskSourceController extends SuperController
{
    @Autowired
    private RiskSourceManageService riskSourceManageService;

	@Autowired
	private RiskSourceRecordManageService riskSourceRecordManageService;

    @Autowired
	private DownloadRiskTemplateUtil riskSourceTemplateUtil;

	@Resource
	private HttpServletResponse response;

	@Resource
	private HttpServletRequest request;

	@Value("${ureport.path}")
	private String path;

	/* Generated Method*/
	@ApiOperation(value = "新增、修改危险源", notes = "Add TSafeRiskSource")
	@PostMapping(value = "/add")
	public BaseResponse addEntity(@RequestBody @Valid TSafeRiskSourceDTO addRequest) throws BusinessException {
		return riskSourceManageService.editRiskSource(addRequest);
	}

	@ApiOperation(value = "删除 危险源 ", notes = "delete TSafeRiskSource By Id")
	@PutMapping(value = "/delete")
	public BaseResponse deleteEntity(@RequestBody TSafeRiskSourceDelParam deleteRequest) throws BusinessException {
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&& StringHelper.isNotEmpty(deleteRequest.getId())){
			baseResponse= riskSourceManageService.deleteById(deleteRequest.getId());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险源 分页列表", notes = "List TSafeRiskSource with page")
	@PostMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSafeRiskSourceVO>>listEntity(@RequestBody TSafeRiskSourceDTOParam param){
		BaseResponse<BaseResponseList<TSafeRiskSourceVO>>baseResponse=new BaseResponse<>();
		BaseResponseList<TSafeRiskSourceVO> resultList= riskSourceManageService.listByPage(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险源 修改记录 分页列表", notes = "List TSafeRiskSource with page")
	@PostMapping(value = "/listByUpdated")
	public  BaseResponse<BaseResponseList<TSafeRiskSourceRecordVO>>listByUpdated(@RequestBody TSafeRiskSourceRecordDTOParam param){
		BaseResponse<BaseResponseList<TSafeRiskSourceRecordVO>>baseResponse=new BaseResponse<>();
		BaseResponseList<TSafeRiskSourceRecordVO> resultList= riskSourceRecordManageService.listByPage(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险源 列表(不分页)", notes = "List TSafeRiskSource with no page")
	@PostMapping(value = "/listAll")
	public  BaseResponse<List<TSafeRiskSourceDTO>>listAll(@RequestBody TSafeRiskSourceDTOParam param){
		BaseResponse<List<TSafeRiskSourceDTO>>baseResponse=new BaseResponse<>();
		List<TSafeRiskSourceDTO> resultList= riskSourceManageService.listAll(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险源 详情 ", notes = "Get TSafeRiskSource By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TSafeRiskSourceVO> getById(String id){
		BaseResponse<TSafeRiskSourceVO> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
			TSafeRiskSourceVO data= riskSourceManageService.findDetailById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "下载危险源导入模板（危险源批量导入模版_1657710447526.xlsx）")
	@GetMapping(value = "/downloadRiskSourceTemplate")
	public void downloadRiskSourceTemplate(HttpServletResponse response, String fileDowName) {
		UserInfo curUser = ContextUtils.getLoginUser();
		String curUserOrgId = curUser.getOrgId();
		riskSourceTemplateUtil.downloadRiskSourceTemplate(response, fileDowName, curUserOrgId);
	}

	@ApiOperation(value = "导出危险源", notes = "")
	@PostMapping("/exportRiskSource")
	public void exportRiskSource(@RequestBody TSafeRiskSourceDTOParam exportReq) throws Exception {

		if(StringUtils.isBlank(exportReq.getOrgId())) {
			UserInfo curUser = ContextUtils.getLoginUser();
			String curUserOrgId = curUser.getOrgId();
			exportReq.setOrgId(curUserOrgId);
		}
		riskSourceManageService.exportRiskResource(request,response,exportReq);
	}

	@ApiOperation(value = "查询指定空间 下的 最大 固有风险等级、现实风险等级{'realLevel': '4','inherentLevel': '2'}", notes = "List TSafeRiskSource with page")
	@GetMapping(value = "/findMaxRiskLevel")
	public  BaseResponse<Map>findMaxRiskLevel(@ApiParam("空间id") @RequestParam String spaceId, @ApiParam("空间等级 1-车间场所；2-作业区域") @RequestParam Integer level){
		BaseResponse<Map> baseResponse=new BaseResponse<>();
		Map resultMap= riskSourceManageService.findMaxRiskLevel(spaceId, level);
		baseResponse.setData(resultMap);
		return baseResponse;
	}
}
