package com.testor.module.contractor.enums;

import com.testor.module.contractor.common.model.constant.ContractorProcessStatus;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum DailyPlanContentEnum {

    /**
     * 待推送
     */
    SPECIAL_WORK_MANAGEMENT("0","特殊作业管理"),

    /**
     * 待提交
     */
    PENDING_SUBMISSION("1", "安全技术管理");

    private final String value; // 状态值
    private final String description; // 状态描述

    /**
     * 根据状态值获取枚举
     *
     * @param value 状态值
     * @return 对应的枚举，如果没有找到则返回 null
     */
    public static DailyPlanContentEnum fromValue(String value) {
        for (DailyPlanContentEnum status : values()) {
            if (status.value.equals(value)) {
                return status;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.value + " - " + this.description;
    }
}
