package com.testor.module.contractor.manage.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorAcceptanceChecklist;
import com.testor.module.contractor.manage.model.dto.TContractorAcceptanceChecklistParam;
import com.testor.module.contractor.manage.model.dto.TContractorAcceptanceChecklistDelParam;
import com.testor.module.contractor.manage.service.TContractorAcceptanceChecklistService;

/**
 * 承包商管理-竣工验收-竣工验收目录清单Controller
 *
 * @author testor-framework
 * @date 2024-12-01 15:01:42
 */
@RestController
@RequestMapping("/manage/checklist")
@Api(value = "TContractorAcceptanceChecklist", tags = "承包商管理-竣工验收-竣工验收目录清单")
@Slf4j
public class TContractorAcceptanceChecklistController extends SuperController
{
    @Autowired
    private TContractorAcceptanceChecklistService tContractorAcceptanceChecklistService;

    /* Generated Method*/
	@ApiOperation(value = "新增 承包商管理-竣工验收-竣工验收目录清单", notes = "Add TContractorAcceptanceChecklist")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorAcceptanceChecklist>addEntity(@RequestBody TContractorAcceptanceChecklist addRequest) {
		BaseResponse<TContractorAcceptanceChecklist> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorAcceptanceChecklist data=BeanHelper.beanToBean(addRequest,  TContractorAcceptanceChecklist.class);
			data.setId(id);
			boolean result= tContractorAcceptanceChecklistService.save(data);
			if(result){
                TContractorAcceptanceChecklist newEntity = new TContractorAcceptanceChecklist();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-竣工验收-竣工验收目录清单 ", notes = "Get TContractorAcceptanceChecklist By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorAcceptanceChecklist> getById(String id){
		BaseResponse<TContractorAcceptanceChecklist> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorAcceptanceChecklist data= tContractorAcceptanceChecklistService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 承包商管理-竣工验收-竣工验收目录清单 ", notes = "Update TContractorAcceptanceChecklist By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorAcceptanceChecklist updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorAcceptanceChecklist data=BeanHelper.beanToBean(updateRequest, TContractorAcceptanceChecklist.class);
			boolean result= tContractorAcceptanceChecklistService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 承包商管理-竣工验收-竣工验收目录清单 ", notes = "delete TContractorAcceptanceChecklist By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorAcceptanceChecklistDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorAcceptanceChecklist data= new TContractorAcceptanceChecklist();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorAcceptanceChecklistService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除承包商管理-竣工验收-竣工验收目录清单", notes = "delete TContractorAcceptanceChecklist by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorAcceptanceChecklistDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorAcceptanceChecklist> tContractorAcceptanceChecklistList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorAcceptanceChecklist data= new TContractorAcceptanceChecklist();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorAcceptanceChecklistList.add(data);
			}
			boolean result = tContractorAcceptanceChecklistService.updateBatchById(tContractorAcceptanceChecklistList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-竣工验收-竣工验收目录清单 分页列表", notes = "List TContractorAcceptanceChecklist with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorAcceptanceChecklist>>listEntity(TContractorAcceptanceChecklistParam param){
		BaseResponse<BaseResponseList<TContractorAcceptanceChecklist>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorAcceptanceChecklist> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorAcceptanceChecklist> queryWrapper=this.createQuery(param);
		Page<TContractorAcceptanceChecklist> resultList= tContractorAcceptanceChecklistService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorAcceptanceChecklist> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商管理-竣工验收-竣工验收目录清单 列表", notes = "List TContractorAcceptanceChecklist all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorAcceptanceChecklist>>listAllEntity(TContractorAcceptanceChecklistParam param){
		BaseResponse<BaseResponseList<TContractorAcceptanceChecklist>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorAcceptanceChecklist> queryWrapper=this.createQuery(param);
		List<TContractorAcceptanceChecklist> resultList=tContractorAcceptanceChecklistService.list(queryWrapper);
		BaseResponseList<TContractorAcceptanceChecklist> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorAcceptanceChecklist> createQuery(TContractorAcceptanceChecklistParam queryParam){
		QueryWrapper<TContractorAcceptanceChecklist> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getAcceptId())){
			queryWrapper.eq(TContractorAcceptanceChecklist.ACCEPT_ID,queryParam.getAcceptId());
		}
		if(StringHelper.isNotEmpty(queryParam.getTitle())){
			queryWrapper.eq(TContractorAcceptanceChecklist.TITLE,queryParam.getTitle());
		}
		if(StringHelper.isNotEmpty(queryParam.getAttachment())){
			queryWrapper.eq(TContractorAcceptanceChecklist.ATTACHMENT,queryParam.getAttachment());
		}
		if(StringHelper.isNotEmpty(queryParam.getIfPass())){
			queryWrapper.eq(TContractorAcceptanceChecklist.IF_PASS,queryParam.getIfPass());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getSortNo())){
			queryWrapper.eq(TContractorAcceptanceChecklist.SORT_NO,queryParam.getSortNo());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorAcceptanceChecklist.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorAcceptanceChecklist.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TContractorAcceptanceChecklist.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
