package com.testor.module.contractor.manage.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorEvaluateDetail;
import com.testor.module.contractor.manage.model.dto.TContractorEvaluateDetailParam;
import com.testor.module.contractor.manage.model.dto.TContractorEvaluateDetailDelParam;
import com.testor.module.contractor.manage.service.TContractorEvaluateDetailService;

/**
 * 承包商考核评价指标明细Controller
 *
 * @author testor-framework
 * @date 2024-11-30 15:42:34
 */
@RestController
@RequestMapping("/contractorManage/evaluateDetail")
@Api(value = "TContractorEvaluateDetail", tags = "承包商考核评价指标明细")
@Slf4j
public class TContractorEvaluateDetailController extends SuperController
{
    @Autowired
    private TContractorEvaluateDetailService tContractorEvaluateDetailService;

    /* Generated Method*/
	@ApiOperation(value = "新增 承包商考核评价指标明细", notes = "Add TContractorEvaluateDetail")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorEvaluateDetail>addEntity(@RequestBody TContractorEvaluateDetail addRequest) {
		BaseResponse<TContractorEvaluateDetail> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorEvaluateDetail data=BeanHelper.beanToBean(addRequest,  TContractorEvaluateDetail.class);
			data.setId(id);
			boolean result= tContractorEvaluateDetailService.save(data);
			if(result){
                TContractorEvaluateDetail newEntity = new TContractorEvaluateDetail();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商考核评价指标明细 ", notes = "Get TContractorEvaluateDetail By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorEvaluateDetail> getById(String id){
		BaseResponse<TContractorEvaluateDetail> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorEvaluateDetail data= tContractorEvaluateDetailService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 承包商考核评价指标明细 ", notes = "Update TContractorEvaluateDetail By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorEvaluateDetail updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorEvaluateDetail data=BeanHelper.beanToBean(updateRequest, TContractorEvaluateDetail.class);
			boolean result= tContractorEvaluateDetailService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 承包商考核评价指标明细 ", notes = "delete TContractorEvaluateDetail By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorEvaluateDetailDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorEvaluateDetail data= new TContractorEvaluateDetail();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorEvaluateDetailService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除承包商考核评价指标明细", notes = "delete TContractorEvaluateDetail by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorEvaluateDetailDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorEvaluateDetail> tContractorEvaluateDetailList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorEvaluateDetail data= new TContractorEvaluateDetail();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorEvaluateDetailList.add(data);
			}
			boolean result = tContractorEvaluateDetailService.updateBatchById(tContractorEvaluateDetailList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商考核评价指标明细 分页列表", notes = "List TContractorEvaluateDetail with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorEvaluateDetail>>listEntity(TContractorEvaluateDetailParam param){
		BaseResponse<BaseResponseList<TContractorEvaluateDetail>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorEvaluateDetail> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorEvaluateDetail> queryWrapper=this.createQuery(param);
		Page<TContractorEvaluateDetail> resultList= tContractorEvaluateDetailService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorEvaluateDetail> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 承包商考核评价指标明细 列表", notes = "List TContractorEvaluateDetail all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorEvaluateDetail>>listAllEntity(TContractorEvaluateDetailParam param){
		BaseResponse<BaseResponseList<TContractorEvaluateDetail>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorEvaluateDetail> queryWrapper=this.createQuery(param);
		List<TContractorEvaluateDetail> resultList=tContractorEvaluateDetailService.list(queryWrapper);
		BaseResponseList<TContractorEvaluateDetail> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorEvaluateDetail> createQuery(TContractorEvaluateDetailParam queryParam){
		QueryWrapper<TContractorEvaluateDetail> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getEvaluateId())){
			queryWrapper.eq(TContractorEvaluateDetail.EVALUATE_ID,queryParam.getEvaluateId());
		}
		if(StringHelper.isNotEmpty(queryParam.getDimension())){
			queryWrapper.eq(TContractorEvaluateDetail.DIMENSION,queryParam.getDimension());
		}
		if(StringHelper.isNotEmpty(queryParam.getFirstLevel())){
			queryWrapper.eq(TContractorEvaluateDetail.FIRST_LEVEL,queryParam.getFirstLevel());
		}
		if(StringHelper.isNotEmpty(queryParam.getSecondLevel())){
			queryWrapper.eq(TContractorEvaluateDetail.SECOND_LEVEL,queryParam.getSecondLevel());
		}
		if(StringHelper.isNotEmpty(queryParam.getEvaluationTerms())){
			queryWrapper.eq(TContractorEvaluateDetail.EVALUATION_TERMS,queryParam.getEvaluationTerms());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getBasicScore())){
			queryWrapper.eq(TContractorEvaluateDetail.BASIC_SCORE,queryParam.getBasicScore());
		}
		if(StringHelper.isNotEmpty(queryParam.getScoreStandard())){
			queryWrapper.eq(TContractorEvaluateDetail.SCORE_STANDARD,queryParam.getScoreStandard());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getScoreDeduct())){
			queryWrapper.eq(TContractorEvaluateDetail.SCORE_DEDUCT,queryParam.getScoreDeduct());
		}
		if(StringHelper.isNotEmpty(queryParam.getIsUse())){
			queryWrapper.eq(TContractorEvaluateDetail.IS_USE,queryParam.getIsUse());
		}
		if(StringHelper.isNotEmpty(queryParam.getDeductDesc())){
			queryWrapper.eq(TContractorEvaluateDetail.DEDUCT_DESC,queryParam.getDeductDesc());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getScore())){
			queryWrapper.eq(TContractorEvaluateDetail.SCORE,queryParam.getScore());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorEvaluateDetail.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorEvaluateDetail.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByAsc(TContractorEvaluateDetail.INDEX_CODE);
		}
		return queryWrapper;
	}
}
