package com.testor.module.contractor.manage.model.dto;

import com.testor.module.contractor.ledger.model.domain.TContractorMaterial;
import com.testor.module.contractor.ledger.model.domain.TContractorPerson;
import com.testor.module.contractor.ledger.model.domain.TContractorProtectiveEquipment;
import com.testor.module.contractor.ledger.model.domain.TContractorTools;
import com.testor.module.contractor.manage.model.domain.TContractorAllow;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class TContractorAllowDTO extends TContractorAllow {

    private String contractorName;

    private String projectName;

    private Long personCount;

    private Long toolsCount;

    private Long materialCount;

    private Long protectiveCount;

    private Long trainingRecordCount;

    @ApiModelProperty("物料列表")
    List<TContractorMaterial> materialList;

    @ApiModelProperty("物料id列表")
    List<String> materialIds;

    @ApiModelProperty("人员列表")
    List<TContractorPerson> personList;

    @ApiModelProperty("人员id列表")
    List<String> personIds;

    @ApiModelProperty("防护用品列表")
    List<TContractorProtectiveEquipment> tContractorProtectiveEquipments;

    @ApiModelProperty("防护用品id列表")
    List<String> protectiveIds;

    @ApiModelProperty("工具列表")
    List<TContractorTools> tContractorTools;

    @ApiModelProperty("工具id列表")
    List<String> toolsIds;


}
