package com.testor.module.duty.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

@TableName("t_sys_dutyalter")
@ApiModel(value = "TSysDutyalter对象", description = "")
@Data
public class TSysDutyalter {
    @ApiModelProperty(value = "主键id")
    @TableField("id")
    private String id;
    @ApiModelProperty(value = "关联ID")
    @TableField("ref_id")
    private String refId;
    @ApiModelProperty(value = "父级ID")
    @TableField("parent_id")
    private String parentId ;
    @ApiModelProperty(value = "租户id")
    @TableField("tenant_id")
    private String tenantId ;
    @ApiModelProperty(value = "流程实例ID")
    @TableField("process_id")
    private String processId ;
    @ApiModelProperty(value = "流程状态")
    @TableField("process_status")
    private String processStatus ;
    @ApiModelProperty(value = "状态：0正常 1删除 2停用")
    @TableField("status")
    private String status ;
    @ApiModelProperty(value = "创建者")
    @TableField("create_by")
    private String createBy ;
    @ApiModelProperty(value = "创建时间")
    @TableField("create_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate ;
    @ApiModelProperty(value = "最后一次更新者")
    @TableField("update_by")
    private String updateBy ;
    @ApiModelProperty(value = "最后一次更新时间")
    @TableField("update_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate ;
    @ApiModelProperty(value = "备注")
    @TableField("remarks")
    private String remarks ;
    @ApiModelProperty(value = "原值班人员信息")
    @TableField("orig_person")
    private String origPerson;
    @ApiModelProperty(value = "现值班人员信息")
    @TableField("now_person")
    private String nowPerson;
    @ApiModelProperty(value = "值班班次")
    @TableField("classes")
    private String classes;
    @ApiModelProperty(value = "值班日期")
    @TableField("duty_date")
    private String dutyDate;
    @ApiModelProperty(value = "审核人")
    @TableField("auditor")
    private String auditor;
    @ApiModelProperty(value = "操作人")
    @TableField("operator")
    private String operator;
    @ApiModelProperty(value = "企业id")
    @TableField("company_id")
    private String companyId ;
    @ApiModelProperty(value = "调整原因")
    @TableField("adjust_cause")
    private String adjustCause ;
    @ApiModelProperty(value = "单位归属")
    @TableField("unit_belong")
    private String unitBelong ;
    @ApiModelProperty(value = "审核意见")
    @TableField("reject_opinion")
    private String rejectOpinion;
    /**
     * 接收对象类型
     */
    @ApiModelProperty(value = "接收对象类型")
    @TableField("receiver_type")
    private String receiverType;

    /**
     * 接收对象
     */
    @ApiModelProperty(value = "接收对象")
    @TableField("receiver_obj")
    private String receiverObj;

    @ApiModelProperty(value = "值班模式")
    @TableField("duty_pattern")
    private String dutyPattern;
}
