package com.testor.module.duty.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.util.List;


/**
 * 作业活动对象 t_sys_task_work
 * 
 * @author testor-framework
 * @date 2022-06-08 14:32:32
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_sys_task_work")
@ApiModel(value = "TSysTaskWork对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSysTaskWork extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 关联id
 */
  @ApiModelProperty(value = "关联id")

  @TableField("ref_id")
  private String refId;
/**
 * 父级ID
 */
  @ApiModelProperty(value = "父级ID")

  @TableField("parent_id")
  private String parentId;
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 活动类别
 */
  @ApiModelProperty(value = "活动类别")

  @TableField("active_category")
  private String activeCategory;
/**
 * 是否危险作业
 */
  @ApiModelProperty(value = "是否危险作业")

  @TableField("is_risk_job")
  private String isRiskJob;
/**
 * 是否涉及相关方
 */
  @ApiModelProperty(value = "是否涉及相关方")

  @TableField("is_involve")
  private String isInvolve;
/**
 * 相关方及人员
 */
  @ApiModelProperty(value = "相关方及人员")

  @TableField("involve_person")
  private String involvePerson;

  /**
   * 相关方及人员
   */
  @ApiModelProperty(value = "相关方及人员")

  @TableField(exist = false)
  private List<String> involvePersonNames;

/**
 * 现场监护人
 */
  @ApiModelProperty(value = "现场监护人")

  @TableField("scene_guardian")
  private String sceneGuardian;
/**
 * 监护人照片
 */
  @ApiModelProperty(value = "监护人照片")

  @TableField("guardian_photo")
  private String guardianPhoto;
/**
 * 现场照片
 */
  @ApiModelProperty(value = "现场照片")

  @TableField("scene_photo")
  private String scenePhoto;
/**
 * 危险作业是否审批
 */
  @ApiModelProperty(value = "危险作业是否审批")

  @TableField("is_task_approval")
  private String isTaskApproval;
/**
 * 是否进行危险作业分析
 */
  @ApiModelProperty(value = "是否进行危险作业分析")

  @TableField("is_task_analysis")
  private String isTaskAnalysis;
/**
 * 是否进行技术交底
 */
  @ApiModelProperty(value = "是否进行技术交底")

  @TableField("is_skill_tell")
  private String isSkillTell;
/**
 * 是否有提及管控的危险作业
 */
  @ApiModelProperty(value = "是否有提及管控的危险作业")

  @TableField("is_control_task")
  private String isControlTask;
/**
 * 提及管控原因描述
 */
  @ApiModelProperty(value = "提及管控原因描述")

  @TableField("control_reason")
  private String controlReason;
/**
 * 作业要素(人，机，料，法，环)是否变更
 */
  @ApiModelProperty(value = "作业要素(人，机，料，法，环)是否变更")

  @TableField("is_element_change")
  private String isElementChange;
/**
 * 重大变更描述及对应措施
 */
  @ApiModelProperty(value = "重大变更描述及对应措施")

  @TableField("change_measure")
  private String changeMeasure;
/**
 * 单位归属
 */
  @ApiModelProperty(value = "单位归属")

  @TableField("unit_belong")
  private String unitBelong;
/**
 * 企业id
 */
  @ApiModelProperty(value = "企业id")

  @TableField("company_id")
  private String companyId;

  @ApiModelProperty(value = "作业名称")
  @TableField("job_name")
  private String jobName;

  @ApiModelProperty(value = "作业/施工内容")
  @TableField("content")
  private String content;

  public static final String ID ="id";
  public static final String REF_ID ="ref_id";
  public static final String PARENT_ID ="parent_id";
  public static final String TENANT_ID ="tenant_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String ACTIVE_CATEGORY ="active_category";
  public static final String IS_RISK_JOB ="is_risk_job";
  public static final String IS_INVOLVE ="is_involve";
  public static final String INVOLVE_PERSON ="involve_person";
  public static final String SCENE_GUARDIAN ="scene_guardian";
  public static final String GUARDIAN_PHOTO ="guardian_photo";
  public static final String SCENE_PHOTO ="scene_photo";
  public static final String IS_TASK_APPROVAL ="is_task_approval";
  public static final String IS_TASK_ANALYSIS ="is_task_analysis";
  public static final String IS_SKILL_TELL ="is_skill_tell";
  public static final String IS_CONTROL_TASK ="is_control_task";
  public static final String CONTROL_REASON ="control_reason";
  public static final String IS_ELEMENT_CHANGE ="is_element_change";
  public static final String CHANGE_MEASURE ="change_measure";
  public static final String UNIT_BELONG ="unit_belong";
  public static final String COMPANY_ID ="company_id";
  public static final String JOB_NAME ="job_name";


}
