package com.testor.module.lease.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.rule.service.SysRuleService;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.module.lease.dao.TLeaseBankDao;
import com.testor.module.lease.model.domain.TLeaseBank;
import com.testor.module.lease.service.TLeaseBankService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 租赁库管理关系Service业务层处理
 *
 * @author testor-framework
 * @date 2022-07-20 10:09:54
 */
@Service
public class TLeaseBankServiceImpl extends SuperServiceImpl<TLeaseBankDao, TLeaseBank> implements TLeaseBankService {
    @Autowired(required = false)
    private TLeaseBankDao tLeaseBankDao;
    @Autowired
    private SysOrgService sysOrgService;
    @Autowired
    private SysRuleService sysRuleService;

    @Override
    public BaseResponse<TLeaseBank> addEntity(TLeaseBank addRequest) throws Exception {
        BaseResponse<TLeaseBank> baseResponse = new BaseResponse<>();
        UserInfo loginUser = ContextUtils.getLoginUser();
        SysOrg sysOrg = sysOrgService.getById(loginUser.getOrgId());
        if (Objects.isNull(sysOrg)) {
            throw new BusinessException("当前登录人部门信息不存在，请联系管理员！");
        }
        TLeaseBank list1 = this.getOne(new QueryWrapper<TLeaseBank>().eq(TLeaseBank.LEASE_NAME, addRequest.getLeaseName())
                .eq(TLeaseBank.ORG_ID, loginUser.getOrgId()));
        if (!ObjectHelper.isEmpty(list1)) {
            if (!list1.getId().equals(addRequest.getId())) {
                throw new BusinessException("租赁库名称不能有重复");
            }
        }
        if (ObjectHelper.isNotEmpty(addRequest)) {
            String id = addRequest.getId();
            TLeaseBank data = BeanHelper.beanToBean(addRequest, TLeaseBank.class);
            if (ObjectHelper.isEmpty(id)) {
                id = IdHelper.getId32bit();
                // 本单位所有租赁库
                List<TLeaseBank> list = this.list(new QueryWrapper<TLeaseBank>().eq(TLeaseBank.ORG_ID, loginUser.getOrgId())
                        .ne(TLeaseBank.STATUS, BizConstants.STATUS_DELETE)
                        .orderByDesc(TLeaseBank.CREATE_DATE));
                if (list.size() > 0) {
                    TLeaseBank tLeaseBank = list.get(0);
                    String s = tLeaseBank.getLeaseCode().split("-")[1];
                    int anInt = Integer.parseInt(s);
                    anInt++;
                    if (anInt <= 9) {
                        data.setLeaseCode(sysOrg.getOrgCode() + "-0" + anInt);
                    } else {
                        data.setLeaseCode(sysOrg.getOrgCode() + "-" + anInt);
                    }
                } else {
                    data.setLeaseCode(sysOrg.getOrgCode() + "-01");
                }
                data.setOrgId(loginUser.getOrgId());
                data.setOrgName(sysOrg.getOrgName());
                data.setLeaseStatus("0");
                data.setId(id);
            }
            boolean result = this.saveOrUpdate(data);
            if (result) {
                TLeaseBank newEntity = new TLeaseBank();
                newEntity.setId(id);
                baseResponse.setData(newEntity);
            }
        }
        return baseResponse;
    }

    @Override
    public BaseResponse<TLeaseBank> getDetail(String id) {
        BaseResponse<TLeaseBank> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            TLeaseBank data = this.getOne(new QueryWrapper<TLeaseBank>().eq(TLeaseBank.ID, id)
                    .ne(TLeaseBank.STATUS, BizConstants.STATUS_DELETE)
                    .ne(TLeaseBank.LEASE_STATUS, BizConstants.STATUS_DELETE)
                    .select(TLeaseBank.LEASE_NAME)
            );
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @Override
    public BaseResponse<BizGeneralResponse> updateEntity(TLeaseBank updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            TLeaseBank data = BeanHelper.beanToBean(updateRequest, TLeaseBank.class);
            boolean result = this.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @Override
    public BaseResponse<List<TLeaseBank>> getOrgLease() {
        BaseResponse<List<TLeaseBank>> baseResponse = new BaseResponse<>();
        String orgId = ContextUtils.getLoginUser().getOrgId();
        List<TLeaseBank> list = this.list(new QueryWrapper<TLeaseBank>()
                .eq(TLeaseBank.LEASE_STATUS, "0")
                .eq(TLeaseBank.ORG_ID, orgId)
        );
        baseResponse.setData(list);
        return baseResponse;
    }

    @Override
    public int getRiskRourceNum(List<String> orgs) {
        return tLeaseBankDao.getRiskRourceNum(orgs);
    }

    @Override
    public int getMajor(List<String> orgs) {
        return tLeaseBankDao.getMajor(orgs);
    }

    @Override
    public int getRiskPoint(List<String> orgs) {
        return tLeaseBankDao.getRiskPoint(orgs);
    }
}
