package com.testor.module.news.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.news.model.domain.NewStatice;
import com.testor.module.news.model.domain.SysNews;
import com.testor.module.news.model.dto.SysNewsParam;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;
import org.mapstruct.Mapper;

import java.util.List;

/**
 * 新闻模块Mapper接口
 *
 * @author gaobingzhuo@testor.com.cn
 * @date 2022-05-07 14:02:06
 */
@Mapper
public interface SysNewsDao extends SuperDao<SysNews> {
    //获取区域公司新闻总数
    List<NewStatice> getAreaCount();
    //获取基层粮库新闻总数
    Integer getBasicGrainNews();
    //获取基层粮库数量
    Integer getBasicGrain();

    //获取已读数据
    IPage<SysNews> getRead(Page<SysNews> resultPage, @Param("param") SysNewsParam param,@Param("startTime") String startTime,@Param("endTime") String endTime,@Param("list") List<String> list,@Param("loginUserId") String loginUserId);

    // 获取未读数据
    IPage<SysNews> getUnRead(Page<SysNews> resultPage, @Param("param") SysNewsParam param,@Param("startTime") String startTime,@Param("endTime") String endTime,@Param("list") List<String> list,@Param("loginUserId") String loginUserId);
}
