package com.testor.module.safeCheck.model.domain;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

import cn.hutool.core.date.DateUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 安全检查计划对象 t_safe_check_plan
 * 
 * @author testor-framework
 * @date 2024-09-03 08:04:18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_check_plan")
@ApiModel(value = "TSafeCheckPlan对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeCheckPlan extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
/**
 * 排查单位id
 */
  @ApiModelProperty(value = "排查单位id")

  @TableField("org_id")
  private String orgId;

  @ApiModelProperty(value = "机构名称")
  @TableField(exist = false)
  private String orgName;
/**
 * 名称
 */
  @ApiModelProperty(value = "名称")

  @TableField("name")
  private String name;
/**
 * 计划开始时间
 */
  @ApiModelProperty(value = "计划开始时间")
  @TableField("start_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startDate;


//  public LocalDateTime getStartDate() {
//    return DateUtil.toLocalDateTime(startDate);
//  }

  /**
 * 计划结束时间
 */
  @ApiModelProperty(value = "计划结束时间")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField("end_date")
  private Date endDate;




//  public LocalDateTime getEndDate() {
//    return DateUtil.toLocalDateTime(endDate);
//  }
/**
 * 是否双休日(0-不包含，跳过；1-包含，不跳过)
 */
  @ApiModelProperty(value = "是否双休日(0-不包含，跳过；1-包含，不跳过)")
  @TableField("in_weekend")
  private String inWeekend;
/**
 * 是否跳过节假日(0-不包含，跳过；1-包含，不跳过)
 */
  @ApiModelProperty(value = "是否跳过节假日(0-不包含，跳过；1-包含，不跳过)")

  @TableField("in_holiday")
  private String inHoliday;
/**
 * 提前小时
 */
  @ApiModelProperty(value = "提前小时" , example = "0")

  @TableField("advance_hour")
  private Long advanceHour;

  @TableField(exist = false)
  @ApiModelProperty(value = "检查人员")
  private List<TSafeCheckPerson> tSafeCheckPersonList;

  @TableField(exist = false)
  @ApiModelProperty(value = "被检查机构")
  private List<TSafeCheckOrg> tSafeCheckOrgs;

  @TableField(exist = false)
  @ApiModelProperty(value = "计划状态 0未开始 1进行中 2已结束")
  private String planStatus;

  @TableField(exist = false)
  @ApiModelProperty(value = "计划状态")
  private String planStatusName;

  @TableField(exist = false)
  @ApiModelProperty(value = "检查类型")
  private String checkType;

  public static final String ID ="id";
  public static final String ORG_ID ="org_id";
  public static final String NAME ="name";
  public static final String START_DATE ="start_date";
  public static final String END_DATE ="end_date";
  public static final String IN_WEEKEND ="in_weekend";
  public static final String IN_HOLIDAY ="in_holiday";
  public static final String ADVANCE_HOUR ="advance_hour";

  public enum PlanStatus {
    NOT_STARTED("0", "未开始"),
    IN_PROGRESS("1", "进行中"),
    COMPLETED("2", "已结束");

    private final String code;
    private final String name;

    PlanStatus(String code, String name) {
      this.code = code;
      this.name = name;
    }

    public String getCode() {
      return code;
    }

    public String getName() {
      return name;
    }

    public static PlanStatus fromCode(String code) {
      for (PlanStatus status : PlanStatus.values()) {
        if (status.code.equals(code)) {
          return status;
        }
      }
      throw new IllegalArgumentException("Unknown code: " + code);
    }
  }


}
