package com.testor.module.threeframework.model.dto;

import com.testor.module.threeframework.model.domain.TThreeTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 三同时管理 删除参数对象
 *
 * @author testor-framework
 * @date 2022-09-15 17:16:20
 */

@Data
@ApiModel(value = "TThreeTime 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TThreeTimeParam extends TThreeTime {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "每页数量")
    private String limit;

    @ApiModelProperty(value = "当前页数")
    private String page;

    @ApiModelProperty(value = "排序字段")
    private String orderBy;

    @ApiModelProperty(value = "排序方式")
    private String orderType;

    @ApiModelProperty(value = "组织机构列表")
    private List<String> orgIds;

    @ApiModelProperty(value = "立项时间筛选 开始")
    private String startDate;

    @ApiModelProperty(value = "立项时间筛选 结束")
    private String endDate;


}
