package com.testor.module.duty.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

@TableName("t_sys_dutymonth")
@ApiModel(value = "TSysDutyMonth对象", description = "")
@Data
public class TSysDutyMonth {
    @ApiModelProperty(value = "主键id")
    @TableField("id")
    private String id ;
    @ApiModelProperty(value = "关联ID")
    @TableField("ref_id")
    private String refId ;
    @ApiModelProperty(value = "父级ID")
    @TableField("parent_id")
    private String parentId ;
    @ApiModelProperty(value = "租户id")
    @TableField("tenant_id")
    private String tenantId ;
    @ApiModelProperty(value = "流程实例ID")
    @TableField("process_id")
    private String processId ;
    @ApiModelProperty(value = "流程状态")
    @TableField("process_status")
    private String processStatus ;
    @ApiModelProperty(value = "状态：0正常 1删除 2停用")
    @TableField("status")
    private String status ;
    @ApiModelProperty(value = "创建者")
    @TableField("create_by")
    private String createBy ;
    @ApiModelProperty(value = "创建时间")
    @TableField("create_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate ;
    @ApiModelProperty(value = "最后一次更新者")
    @TableField("update_by")
    private String updateBy ;
    @ApiModelProperty(value = "最后一次更新时间")
    @TableField("update_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate ;
    @ApiModelProperty(value = "备注")
    @TableField("remarks")
    private String remarks ;
    @ApiModelProperty(value = "值班日期", required = true)
    @TableField("duty_date")
    private String dutyDate ;
    @ApiModelProperty(value = "值班模式", required = true)
    @TableField("duty_pattern")
    private String dutyPattern ;
    @ApiModelProperty(value = "早班时间", required = true)
    @TableField("mor_time")
    private String morTime ;
    @ApiModelProperty(value = "中班时间", required = true)
    @TableField("noon_time")
    private String noonTime ;
    @ApiModelProperty(value = "晚班时间", required = true)
    @TableField("late_time")
    private String lateTime ;
    @ApiModelProperty(value = "全天时间", required = true)
    @TableField("all_time")
    private String allTime ;
    @ApiModelProperty(value = "企业id", required = true)
    @TableField("company_id")
    private String companyId ;
    @ApiModelProperty(value = "企业名称")
    @TableField("company_name")
    private String companyName ;
    @ApiModelProperty(value = "租赁单位名称")
    @TableField("tenant_name")
    private String tenantName ;
    @ApiModelProperty(value = "单位归属", required = true)
    @TableField("unit_belong")
    private String unitBelong ;
    @ApiModelProperty(value = "组织机构id")
    @TableField("org_id")
    private String orgId;
    /**
     * 接收对象类型
     */
    @ApiModelProperty(value = "接收对象类型")
    @TableField("receiver_type")
    private String receiverType;

    /**
     * 接收对象
     */
    @ApiModelProperty(value = "接收对象")
    @TableField("receiver_obj")
    private String receiverObj;

    @ApiModelProperty(value = "驳回意见")
    @TableField("reject_opinion")
    private String rejectOpinion;

    @TableField(exist = false)
    private String startDate;

    @TableField(exist = false)
    private String endDate;

    @TableField(exist = false)
    private String type;
}
