package com.testor.module.emergency.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.module.emergency.model.domain.TEmergencyWorkingGroup;
import com.testor.module.emergency.model.domain.TEmergencyWorkingUser;
import com.testor.module.emergency.model.dto.TEmergencyWorkingGroupDTO;
import com.testor.module.emergency.model.dto.TEmergencyWorkingGroupParam;
import com.testor.module.emergency.model.dto.TEmergencyWorkingGroupUpdateAddDel;
import com.testor.module.emergency.model.dto.TEmergencyWorkingUserParam;
import com.testor.module.emergency.model.vo.TEmergencyWorkingUserVO;
import com.testor.module.emergency.service.TEmergencyWorkingGroupService;
import com.testor.module.emergency.service.TEmergencyWorkingUserService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 应急救援组织机构Controller
 *
 * @author testor-framework
 * @date 2022-11-17 11:51:40
 */
@RestController
@RequestMapping("/module/group")
@Api(value = "TEmergencyWorkingGroup", tags = "应急救援组织机构")
@Slf4j
public class TEmergencyWorkingGroupController extends SuperController {

    @Autowired
    private TEmergencyWorkingGroupService tEmergencyWorkingGroupService;

    @Autowired(required = false)
    private TEmergencyWorkingUserService tEmergencyWorkingUserService;
    /* Generated Method*/
    @ApiOperation(value = "新增、修改、删除应急救援组织机构")
    @PostMapping(value = "/updateAddDel")
    public BaseResponse<BizGeneralResponse> updateAddDel(@RequestBody TEmergencyWorkingGroupUpdateAddDel tEmergencyWorkingGroupUpdateAddDel) throws BusinessException {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        boolean result = tEmergencyWorkingGroupService.updateAddDel(tEmergencyWorkingGroupUpdateAddDel);
        baseResponse.setData(BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        return baseResponse;
    }

    @ApiOperation(value = "获取工作组列表")
    @GetMapping(value = "/getWorkingGroupList")
    public BaseResponse<List<TEmergencyWorkingGroupDTO>> getWorkingGroupList(String id) {
        BaseResponse<List<TEmergencyWorkingGroupDTO>> baseResponse = new BaseResponse<>();
        List<TEmergencyWorkingGroupDTO> data = tEmergencyWorkingGroupService.getWorkingGroupList(id);
        baseResponse.setData(data);

        return baseResponse;
    }

    @ApiOperation(value = "获取工作组列表和人员")
    @GetMapping(value = "/getWorkingGroupAndUserList")
    public BaseResponse<List<TEmergencyWorkingUserVO>> getWorkingGroupListAndUser(String id) {
        BaseResponse<List<TEmergencyWorkingUserVO>> baseResponse = new BaseResponse<>();
        List<TEmergencyWorkingUserVO> data = tEmergencyWorkingGroupService.getWorkingGroupListAndUser(id);
        baseResponse.setData(data);

        return baseResponse;
    }

    @ApiOperation(value = "获取职责查看列表 ", notes = "")
    @PutMapping(value = "/getResponsibilityList")
    public BaseResponse<IPage> getResponsibilityList(@RequestBody TEmergencyWorkingGroupParam tEmergencyWorkingGroupParam) {
        BaseResponse<IPage> baseResponse = new BaseResponse<>();
        IPage data = tEmergencyWorkingGroupService.getResponsibilityList(tEmergencyWorkingGroupParam);
        baseResponse.setData(data);

        return baseResponse;
    }

    @ApiOperation(value = "获取人员列表")
    @PutMapping(value = "/getUserList")
    public BaseResponse<IPage> getUserList(@RequestBody TEmergencyWorkingUserParam tEmergencyWorkingUserParam) {
        BaseResponse<IPage> baseResponse = new BaseResponse<>();
        IPage data = tEmergencyWorkingUserService.getUserList(tEmergencyWorkingUserParam);
        baseResponse.setData(data);

        return baseResponse;
    }

    @ApiOperation(value = "新增和修改人员")
    @PutMapping(value = "/addAndUpdateUser")
    public BaseResponse<BizGeneralResponse> addAndUpdateUser(@RequestBody TEmergencyWorkingUser tEmergencyWorkingUser) throws BusinessException {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        boolean result = tEmergencyWorkingUserService.addAndUpdateUser(tEmergencyWorkingUser);
        baseResponse.setData(BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        return baseResponse;
    }

    @ApiOperation(value = "删除人员")
    @GetMapping(value = "/deleteUser")
    public BaseResponse<BizGeneralResponse> deleteUser(String id) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        UpdateWrapper<TEmergencyWorkingUser> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id",id).set("status",1);
        boolean result = tEmergencyWorkingUserService.update(updateWrapper);
        baseResponse.setData(BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        return baseResponse;
    }



    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TEmergencyWorkingGroup> createQuery(TEmergencyWorkingGroupParam queryParam) {
        QueryWrapper<TEmergencyWorkingGroup> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getGroupId())) {
            queryWrapper.eq(TEmergencyWorkingGroup.GROUP_ID, queryParam.getGroupId());
        }
        if (StringHelper.isNotEmpty(queryParam.getGroupKey())) {
            queryWrapper.eq(TEmergencyWorkingGroup.GROUP_KEY, queryParam.getGroupKey());
        }
        if (StringHelper.isNotEmpty(queryParam.getName())) {
            queryWrapper.like(TEmergencyWorkingGroup.NAME, queryParam.getName());
        }
        if (StringHelper.isNotEmpty(queryParam.getResponsibility())) {
            queryWrapper.eq(TEmergencyWorkingGroup.RESPONSIBILITY, queryParam.getResponsibility());
        }
        if (StringHelper.isNotEmpty(queryParam.getOrgId())) {
            queryWrapper.eq(TEmergencyWorkingGroup.ORG_ID, queryParam.getOrgId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TEmergencyWorkingGroup.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TEmergencyWorkingGroup.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TEmergencyWorkingGroup.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
