package com.testor.module.hazard.task;

import com.testor.common.core.utils.StringUtils;
import com.testor.common.util.SpringBeanFactory;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.model.enums.WorkPlanStatusEnum;
import com.testor.module.hazard.service.THazardWorkPlanService;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.task.service.delegate.DelegateTask;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class DynamicCandidateUsersListener implements TaskListener {

    private final THazardWorkPlanService tHazardWorkPlanService;
    public DynamicCandidateUsersListener() {
        this.tHazardWorkPlanService = SpringBeanFactory.getBean(THazardWorkPlanService.class);
    }

    @Override
    public void notify(DelegateTask delegateTask) {
        // 动态为任务设置候选用户
        // 获取流程变量，确定它是否是一个 List
        Object workSiteResponsible = delegateTask.getVariable("workSiteResponsible");
        List<String> participants = new ArrayList<>();
        if (workSiteResponsible != null && StringUtils.isNotBlank(workSiteResponsible.toString())) {
            participants = Arrays.asList(workSiteResponsible.toString().replace("0-", "").split(","));
        }
        Object checkUser = delegateTask.getVariable("checkUser");
        if (checkUser != null && StringUtils.isNotBlank(checkUser.toString())) {
            participants = Arrays.asList((checkUser.toString().replace("0-", "")  // 替换掉所有的 "0-" 为 ""
                    .split(",")));
        }
        Object responsiblePerson = delegateTask.getVariable("responsiblePerson");
        if (responsiblePerson != null && StringUtils.isNotBlank(responsiblePerson.toString())) {
            participants = Arrays.asList(responsiblePerson.toString().replace("0-", "").split(","));
        }

        // 动态为任务设置候选用户
        for (String userId : participants) {
            delegateTask.addCandidateUser(userId);
        }
        String name = delegateTask.getName();

        if ("安全风险分析".equals(name)){
            //修改交底状态
            String bizId = delegateTask.getVariable("bizKeyId").toString();
            THazardWorkPlan byId = tHazardWorkPlanService.getById(bizId);
            if (byId != null){
                byId.setWorkStatus(WorkPlanStatusEnum.RISK_ANALYSIS.getValue());
                tHazardWorkPlanService.updateById(byId);
            }
        }

        if ("安全条件确认".equals(name)){
            //修改交底状态
            String bizId = delegateTask.getVariable("bizKeyId").toString();
            THazardWorkPlan byId = tHazardWorkPlanService.getById(bizId);
            if (byId != null){
                byId.setWorkStatus(WorkPlanStatusEnum.CONDITION_CONFIRMATION.getValue());
                tHazardWorkPlanService.updateById(byId);
            }
        }

        if (name.contains("安全许可证")) {
            //修改交底状态
            String bizId = delegateTask.getVariable("bizKeyId").toString();
            THazardWorkPlan byId = tHazardWorkPlanService.getById(bizId);
            if (byId != null) {
                if ("安全许可证申请".equals(name)) {
                    byId.setWorkStatus(WorkPlanStatusEnum.PERMIT.getValue());
                    tHazardWorkPlanService.updateById(byId);
                }else {
                    //许可证状态
                    byId.setLicenseStatus("1");
                    tHazardWorkPlanService.updateById(byId);
                }
            }
        }



        if ("安全技术交底".equals(name)){
            //修改交底状态
            String bizId = delegateTask.getVariable("bizKeyId").toString();
            THazardWorkPlan byId = tHazardWorkPlanService.getById(bizId);
            if (byId != null){
                byId.setWorkStatus(WorkPlanStatusEnum.TECHNICAL_EXPLANATION.getValue());
                tHazardWorkPlanService.updateById(byId);
            }
        }

        if ("安全许可证关闭".equals(name)){
            //修改交底状态
            String bizId = delegateTask.getVariable("bizKeyId").toString();
            THazardWorkPlan byId = tHazardWorkPlanService.getById(bizId);
            if (byId != null){
                /*安全技术交底时设置实际开始时间
                安全许可证关闭时设置实际结束时间
                到此节点后通过后才设置值*/
                // 获取当前时间
                /*Date currentTime = new Date();
                // 获取scheduledStartTime和scheduledEndTime的时间差
                long timeDifference = byId.getScheduledEndTime().getTime() - byId.getScheduledStartTime().getTime();
                // 计算实际结束作业时间（当前时间 + 时间差）
                Date actualEndTime = new Date(currentTime.getTime() + timeDifference);
                //更新计划作业时间
                byId.setActualStartTime(new Date());
                byId.setActualEndTime(actualEndTime);*/

                byId.setWorkStatus(WorkPlanStatusEnum.TO_BE_CLOSED.getValue());
                tHazardWorkPlanService.updateById(byId);
                //发送消息通知
                tHazardWorkPlanService.hazardousWorkMessageAlerts();
            }
        }

    }
}
