package com.testor.module.notice.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.module.notice.model.domain.DetailNotice;
import com.testor.module.notice.model.domain.TSysNotice;
import com.testor.module.notice.model.dto.TSysNoticeDelParam;
import com.testor.module.notice.model.dto.TSysNoticeParam;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * noticeService接口
 * 
 * @author tong-framework
 * @date 2022-04-27 18:10:12
 */
public interface TSysNoticeService extends SuperService<TSysNotice> {
    //添加公告
    BaseResponse<TSysNotice> addEntity(TSysNotice addRequest)throws Exception;
    //根据id获取公告
    BaseResponse getByIds(String id);
    //修改公告
    BaseResponse updateEntity( DetailNotice updateRequest) throws Exception;

    //删除公告
    BaseResponse deleteNotice(TSysNoticeDelParam tSysNoticeDelParam) throws Exception;

    //获取公告详情
    BaseResponse detail( TSysNotice tSysNotice)throws Exception;
    //获取公告详情 修改已读未读状态
    BaseResponse getIsRead( TSysNotice tSysNotice)throws Exception;
    //获取功能分页展示 我的发布和草稿箱
    BaseResponse<BaseResponseList<TSysNotice>> listEntity (TSysNoticeParam param, String startTime , String endTime);

    //获取分页接收的公告
    BaseResponse<BaseResponseList<TSysNotice>> listAllEntity(TSysNoticeParam param,String startTime,String endTime);

    // 获取已读数据
    IPage<TSysNotice> getRead(TSysNoticeParam param, String startTime, String endTime, List<String> list, String loginUserId, String orgId);

    // 获取未读数据
    IPage<TSysNotice> getUnRead(TSysNoticeParam param, String startTime, String endTime, List<String> list, String loginUserId,String orgId);

    IPage<TSysNotice> getNewsAndNotice(TSysNoticeParam param , String orgId);
}
