package com.testor.module.partner.dao;


import cn.hutool.core.date.DateTime;
import com.testor.module.partner.model.domain.TJobStatistics;
import com.testor.module.partner.model.dto.TJobStatisticsParam;
import com.testor.module.partner.model.vo.DangerousNumVO;
import com.testor.module.partner.model.vo.HazardousOperation;
import com.testor.module.partner.model.vo.RegionalStatisticsVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 现场作业统计Mapper接口
 *
 * @author testor-framework
 * @date 2022-11-02 10:42:06
 */
public interface TJobStatisticsDao extends SuperDao<TJobStatistics> {
    List<DangerousNumVO> dangerousNum(@Param("param") TJobStatisticsParam param);

    List<DangerousNumVO> regionalGrain(@Param("param")TJobStatisticsParam param);

    List<DangerousNumVO> area(@Param("param")TJobStatisticsParam param);

    List<DangerousNumVO> grainDepot(@Param("param")TJobStatisticsParam param);

    List<HazardousOperation> distributionSum(@Param("param")TJobStatisticsParam param);

    List<HazardousOperation> distributionRegionalCompanyGrainDepot(@Param("param")TJobStatisticsParam param);

    List<HazardousOperation> distributionRegionalCompaniesRentStorage(@Param("param")TJobStatisticsParam param);

    List<HazardousOperation> distributionGrainDepot(@Param("param")TJobStatisticsParam param);

    List<DangerousNumVO> foreignHeadquarters(@Param("param")TJobStatisticsParam param);

    List<DangerousNumVO> foreignRegionalGrain(@Param("param")TJobStatisticsParam param);

    List<DangerousNumVO> foreignRentalLibrary(@Param("param")TJobStatisticsParam param);

    List<DangerousNumVO> foreignGrainDepot(@Param("param")TJobStatisticsParam param);

    List<RegionalStatisticsVO> regionalStatistics(@Param("param")TJobStatisticsParam param);

    List<RegionalStatisticsVO> hazardousWork(@Param("orgIds")List<String> orgIds);

    List<RegionalStatisticsVO> regionalStatisticsGrain(@Param("param")TJobStatisticsParam tJobStatisticsParam);

    Long regionalStatisticsCount(@Param("param")TJobStatisticsParam tJobStatisticsParam);

    Long regionalStatisticsCountGrain(@Param("param")TJobStatisticsParam tJobStatisticsParam);

    RegionalStatisticsVO selectCountBatch(@Param("orgIds") List<String> orgIds, @Param("today") String today);
}
