package com.testor.module.report.dto;

import lombok.Data;

/**
 * 本单位值班日志下载
 */
//@Data
 @Data
public class ReturnDutyLog {
    /**
     * 值班日期
     */
    private String dutyDate;
    /**
     * 值班领导
     */
    private String dutyLeader;
    /**
     * 天气情况
     */
    private String weather;
    /**
     * 时段（工作日，节假日）
     */
    private String timeSection;
    /**
     * 当班门岗保卫姓名
     */
    private String defendName;
    /**
     * 当班其他人员
     */
    private String otherStaffs;
    /**
     * 其他工作
     */
    private String otherWork;
    /**
     * 突发情况
     */
    private String emergency;
    /**
     * 遗留问题办理情况
     */
    private String issueApply;
    /**
     * 交接内容注意事项
     */
    private String attentionMatter;
    /**
     * 交接内容采取措施
     */
    private String takeStep;
    /**
     * 交接内容遗留问题
     */
    private String handoverIssue;
    /**
     * 交班领导签字
     */
    private String handoverSign;
    /**
     * 接班领导签字
     */
    private String successionSign;
    /**
     * 活动类别
     */
    private String activeCategory;
    /**
     * 是否危险作业
     */
    private String isRiskJob;
    /**
     * 是否涉及相关方
     */
    private String isInvolve;
    /**
     * 相关方及人员
     */
    private String involvePerson;

    /**
     * 现场监护人
     */
    private String sceneGuardian;
    /**
     * 监护人照片
     */
    private String guardianPhoto;
    /**
     * 现场照片
     */
    private String scenePhoto;
    /**
     * 危险作业是否审批
     */
    private String isTaskApproval;
    /**
     * 是否进行危险作业分析
     */
    private String isTaskAnalysis;
    /**
     * 是否进行技术交底
     */
    private String isSkillTell;
    /**
     * 是否有提及管控的危险作业
     */
    private String isControlTask;
    /**
     * 提及管控原因描述
     */
    private String controlReason;
    /**
     * 作业要素(人，机，料，法，环)是否变更
     */
    private String isElementChange;
    /**
     * 重大变更描述及对应措施
     */
    private String changeMeasure;
}
