package com.testor.module.safeCheck.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.safeCheck.model.domain.TSafeHazardCheckTask;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 巡检任务 删除参数对象
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:59
 */

@Data
@ApiModel(value = "TSafeHazardCheckTask 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TSafeHazardCheckTaskParam extends TSafeHazardCheckTask {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "排查人")
	private String userName;

	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "任务开始时间-起始时间")
	private Date startDateStart;

	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "任务开始时间-截止时间")
	private Date startDateEnd;

	@ApiModelProperty(value = "企业选择")
	private List<String> condOrgIdList;
}
