/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.monitor.core.instrument;

import com.tongweb.commons.monitor.core.instrument.Counter;
import com.tongweb.commons.monitor.core.instrument.DistributionSummary;
import com.tongweb.commons.monitor.core.instrument.FunctionCounter;
import com.tongweb.commons.monitor.core.instrument.FunctionTimer;
import com.tongweb.commons.monitor.core.instrument.Gauge;
import com.tongweb.commons.monitor.core.instrument.LongTaskTimer;
import com.tongweb.commons.monitor.core.instrument.Measurement;
import com.tongweb.commons.monitor.core.instrument.MeterRegistry;
import com.tongweb.commons.monitor.core.instrument.Statistic;
import com.tongweb.commons.monitor.core.instrument.Tag;
import com.tongweb.commons.monitor.core.instrument.Tags;
import com.tongweb.commons.monitor.core.instrument.TimeGauge;
import com.tongweb.commons.monitor.core.instrument.Timer;
import com.tongweb.commons.monitor.core.instrument.config.NamingConvention;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface Meter {
    public static Builder builder(String name, Type type, Iterable<Measurement> measurements) {
        return new Builder(name, type, measurements);
    }

    public Id getId();

    public Iterable<Measurement> measure();

    default public <T> T match(Function<Gauge, T> visitGauge, Function<Counter, T> visitCounter, Function<Timer, T> visitTimer, Function<DistributionSummary, T> visitSummary, Function<LongTaskTimer, T> visitLongTaskTimer, Function<TimeGauge, T> visitTimeGauge, Function<FunctionCounter, T> visitFunctionCounter, Function<FunctionTimer, T> visitFunctionTimer, Function<Meter, T> visitMeter) {
        if (this instanceof TimeGauge) {
            return visitTimeGauge.apply((TimeGauge)this);
        }
        if (this instanceof Gauge) {
            return visitGauge.apply((Gauge)this);
        }
        if (this instanceof Counter) {
            return visitCounter.apply((Counter)this);
        }
        if (this instanceof Timer) {
            return visitTimer.apply((Timer)this);
        }
        if (this instanceof DistributionSummary) {
            return visitSummary.apply((DistributionSummary)this);
        }
        if (this instanceof LongTaskTimer) {
            return visitLongTaskTimer.apply((LongTaskTimer)this);
        }
        if (this instanceof FunctionCounter) {
            return visitFunctionCounter.apply((FunctionCounter)this);
        }
        if (this instanceof FunctionTimer) {
            return visitFunctionTimer.apply((FunctionTimer)this);
        }
        return visitMeter.apply(this);
    }

    default public void use(Consumer<Gauge> visitGauge, Consumer<Counter> visitCounter, Consumer<Timer> visitTimer, Consumer<DistributionSummary> visitSummary, Consumer<LongTaskTimer> visitLongTaskTimer, Consumer<TimeGauge> visitTimeGauge, Consumer<FunctionCounter> visitFunctionCounter, Consumer<FunctionTimer> visitFunctionTimer, Consumer<Meter> visitMeter) {
        if (this instanceof TimeGauge) {
            visitTimeGauge.accept((TimeGauge)this);
        } else if (this instanceof Gauge) {
            visitGauge.accept((Gauge)this);
        } else if (this instanceof Counter) {
            visitCounter.accept((Counter)this);
        } else if (this instanceof Timer) {
            visitTimer.accept((Timer)this);
        } else if (this instanceof DistributionSummary) {
            visitSummary.accept((DistributionSummary)this);
        } else if (this instanceof LongTaskTimer) {
            visitLongTaskTimer.accept((LongTaskTimer)this);
        } else if (this instanceof FunctionCounter) {
            visitFunctionCounter.accept((FunctionCounter)this);
        } else if (this instanceof FunctionTimer) {
            visitFunctionTimer.accept((FunctionTimer)this);
        } else {
            visitMeter.accept(this);
        }
    }

    default public void close() {
    }

    public static class Builder {
        private final String name;
        private final Type type;
        private final Iterable<Measurement> measurements;
        private Tags tags = Tags.empty();
        private String description;
        private String baseUnit;

        private Builder(String name, Type type, Iterable<Measurement> measurements) {
            this.name = name;
            this.type = type;
            this.measurements = measurements;
        }

        public Builder tags(String ... tags) {
            return this.tags(Tags.of(tags));
        }

        public Builder tags(Iterable<Tag> tags) {
            this.tags = this.tags.and(tags);
            return this;
        }

        public Builder tag(String key, String value) {
            this.tags = this.tags.and(key, value);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder baseUnit(String unit) {
            this.baseUnit = unit;
            return this;
        }

        public Meter register(MeterRegistry registry) {
            return registry.register(new Id(this.name, this.tags, this.baseUnit, this.description, this.type), this.type, this.measurements);
        }
    }

    public static class Id {
        private final String name;
        private final Tags tags;
        private final Type type;
        private final Id syntheticAssociation;
        private final String description;
        private final String baseUnit;

        Id(String name, Tags tags, String baseUnit, String description, Type type, Id syntheticAssociation) {
            this.name = name;
            this.tags = tags;
            this.baseUnit = baseUnit;
            this.description = description;
            this.type = type;
            this.syntheticAssociation = syntheticAssociation;
        }

        public Id(String name, Tags tags, String baseUnit, String description, Type type) {
            this(name, tags, baseUnit, description, type, null);
        }

        public Id withName(String newName) {
            return new Id(newName, this.tags, this.baseUnit, this.description, this.type);
        }

        public Id withTag(Tag tag) {
            return this.withTags(Collections.singletonList(tag));
        }

        public Id withTags(Iterable<Tag> tags) {
            return new Id(this.name, Tags.concat(this.getTags(), tags), this.baseUnit, this.description, this.type);
        }

        public Id replaceTags(Iterable<Tag> tags) {
            return new Id(this.name, Tags.of(tags), this.baseUnit, this.description, this.type);
        }

        public Id withTag(Statistic statistic) {
            return this.withTag(Tag.of("statistic", statistic.getTagValueRepresentation()));
        }

        public Id withBaseUnit(String newBaseUnit) {
            return new Id(this.name, this.tags, newBaseUnit, this.description, this.type);
        }

        public String getName() {
            return this.name;
        }

        public List<Tag> getTags() {
            ArrayList tags = new ArrayList();
            this.tags.forEach(tags::add);
            return Collections.unmodifiableList(tags);
        }

        public Iterable<Tag> getTagsAsIterable() {
            return this.tags;
        }

        public String getTag(String key) {
            for (Tag tag : this.tags) {
                if (!tag.getKey().equals(key)) continue;
                return tag.getValue();
            }
            return null;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }

        public String getConventionName(NamingConvention namingConvention) {
            return namingConvention.name(this.name, this.type, this.baseUnit);
        }

        public List<Tag> getConventionTags(NamingConvention namingConvention) {
            return StreamSupport.stream(this.tags.spliterator(), false).map(t -> Tag.of(namingConvention.tagKey(t.getKey()), namingConvention.tagValue(t.getValue()))).collect(Collectors.toList());
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return "MeterId{name='" + this.name + '\'' + ", tags=" + this.tags + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id meterId = (Id)o;
            return Objects.equals(this.name, meterId.name) && Objects.equals(this.tags, meterId.tags);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.tags.hashCode();
            return result;
        }

        public Type getType() {
            return this.type;
        }

        public Id syntheticAssociation() {
            return this.syntheticAssociation;
        }
    }

    public static enum Type {
        COUNTER,
        GAUGE,
        LONG_TASK_TIMER,
        TIMER,
        DISTRIBUTION_SUMMARY,
        OTHER;

    }
}

