/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.role.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.resource.service.SysResourceService;
import com.testor.biz.sys.role.RoleEnumCode;
import com.testor.biz.sys.role.model.domain.SysRole;
import com.testor.biz.sys.role.model.dto.SysRoleCreateAndUpdateRequest;
import com.testor.biz.sys.role.model.dto.SysRoleDeleteBatchRequest;
import com.testor.biz.sys.role.model.dto.SysRoleDeleteRequest;
import com.testor.biz.sys.role.model.dto.SysRoleParam;
import com.testor.biz.sys.role.model.dto.SysRoleResourceRequest;
import com.testor.biz.sys.role.service.SysRoleService;
import com.testor.biz.sys.roleResource.model.domain.SysRoleResource;
import com.testor.biz.sys.roleResource.service.SysRoleResourceService;
import com.testor.biz.sys.userRole.service.SysUserRoleService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="SysRole", tags={"SysRole \u89d2\u8272"})
@RequestMapping(value={"/role"})
public class SysRoleController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(SysRoleController.class);
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SysResourceService sysResourceService;
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private SysRoleResourceService sysRoleResourceService;
    @Autowired
    private SysOrgService sysOrgService;

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u673a\u6784\u4e0b\u7684\u89d2\u8272", notes="")
    @GetMapping(value={"/getOrgRole"})
    public BaseResponse<List<SysRole>> getOrgRole() throws BusinessException {
        BaseResponse response = new BaseResponse();
        SysOrg sysOrg = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)ContextUtils.getLoginUser().getOrgId())));
        if (Objects.isNull((Object)sysOrg)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u90e8\u95e8\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        List list = this.sysRoleService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tree_level", (Object)sysOrg.getTreeLevel())).ne((Object)"status", (Object)"1")).orderByAsc((Object)"role_sort"));
        response.setData((Object)list);
        return response;
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868\u4fe1\u606f", notes="\u83b7\u53d6\u89d2\u8272\u5217\u8868\u4fe1\u606f List Roles")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<SysRole>> listEntity(@Valid SysRoleParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<SysRole> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.sysRoleService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(this.sysRoleService.count((Wrapper)queryWrapper) + "");
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u65b0\u589e\u89d2\u8272\u4fe1\u606f", notes="\u65b0\u589e\u89d2\u8272\u4fe1\u606f Add Roles")
    @PostMapping(value={"/add"})
    public BaseResponse<SysRole> addEntity(@Valid @RequestBody SysRoleCreateAndUpdateRequest addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isEmpty((Object)addRequest)) {
            throw new ApiException(RoleEnumCode.ROLE_PARAM_IS_NULL.transform());
        }
        SysRole temp = (SysRole)((Object)this.sysRoleService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"role_name", (Object)addRequest.getRoleName())).ne((Object)"status", (Object)"1")).last("LIMIT 1")));
        if (ObjectHelper.isNotEmpty((Object)((Object)temp))) {
            throw new ApiException(RoleEnumCode.ROLE_NAME_ALREADY_EXISTS.transform());
        }
        SysRole data = (SysRole)((Object)BeanHelper.beanToBean((Object)addRequest, SysRole.class));
        data.setRoleId(IdHelper.getId32bit());
        this.sysRoleService.save((Object)data);
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272\u4fe1\u606f", notes="\u4fee\u6539\u89d2\u8272\u4fe1\u606f edit role")
    @PutMapping(value={"/update"})
    public BaseResponse<SysRole> updateEntity(@Valid @RequestBody SysRoleCreateAndUpdateRequest updateRequest) {
        SysRole temp;
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isEmpty((Object)updateRequest)) {
            throw new ApiException(RoleEnumCode.ROLE_PARAM_IS_NULL.transform());
        }
        if (StringHelper.isEmpty((CharSequence)updateRequest.getRoleId())) {
            throw new ApiException(RoleEnumCode.ROLE_ID_NONEXISTENT.transform());
        }
        SysRole newRole = (SysRole)((Object)BeanHelper.beanToBean((Object)updateRequest, SysRole.class));
        SysRole oldRole = (SysRole)((Object)this.sysRoleService.getById((Serializable)((Object)updateRequest.getRoleId())));
        if (ObjectHelper.isEmpty((Object)((Object)oldRole))) {
            throw new ApiException(RoleEnumCode.ROLE_ID_NONEXISTENT.transform());
        }
        if (!newRole.getRoleName().equals(oldRole.getRoleName()) && ObjectHelper.isNotEmpty((Object)((Object)(temp = (SysRole)((Object)this.sysRoleService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"role_name", (Object)newRole.getRoleName())).ne((Object)"status", (Object)"1")).last("LIMIT 1"))))))) {
            throw new ApiException(RoleEnumCode.ROLE_NAME_ALREADY_EXISTS.transform());
        }
        this.sysRoleService.updateById((Object)newRole);
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u89d2\u8272\u4fe1\u606f", notes="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u89d2\u8272\u4fe1\u606f get Role info")
    @GetMapping(value={"/get"})
    public BaseResponse<SysRole> getEntity(String roleId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isEmpty((CharSequence)roleId)) {
            throw new ApiException(RoleEnumCode.ROLE_ID_NONEXISTENT.transform());
        }
        SysRole role = (SysRole)((Object)this.sysRoleService.getById((Serializable)((Object)roleId)));
        if (ObjectHelper.isEmpty((Object)((Object)role))) {
            throw new ApiException(RoleEnumCode.ROLE_ID_NONEXISTENT.transform());
        }
        baseResponse.setData((Object)role);
        return baseResponse;
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u62e5\u6709\u8d44\u6e90\u4fe1\u606f", notes="\u67e5\u8be2\u89d2\u8272\u62e5\u6709\u8d44\u6e90\u4fe1\u606f get resource by role")
    @GetMapping(value={"/auth/show"})
    public BaseResponse<List<Map<String, Object>>> showAuthEntity(String roleId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isEmpty((CharSequence)roleId)) {
            throw new ApiException(RoleEnumCode.REQUIRED_ITEMS_MISSING.transform());
        }
        List resources = this.sysResourceService.list((Wrapper)new QueryWrapper().ne(true, (Object)"status", (Object)"1"));
        List checkedResources = this.sysRoleResourceService.list((Wrapper)new QueryWrapper().eq((Object)"role_id", (Object)roleId));
        List checkedResourceIds = checkedResources.stream().map(SysRoleResource::getResourceId).collect(Collectors.toList());
        List data = BeanHelper.beansToMaps((List)resources);
        for (Map resource : data) {
            if (checkedResourceIds.contains(String.valueOf(resource.get("resourceId")))) {
                resource.put("isChecked", true);
                continue;
            }
            resource.put("isChecked", false);
        }
        baseResponse.setData((Object)data);
        return baseResponse;
    }

    @ApiOperation(value="\u4e3a\u6307\u5b9a\u89d2\u8272\u5206\u914d\u83dc\u5355\u8d44\u6e90", notes="\u4e3a\u6307\u5b9a\u89d2\u8272\u5206\u914d\u83dc\u5355\u8d44\u6e90 assign")
    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"/auth"})
    public BaseResponse<SysRole> assignEntity(@Valid @RequestBody SysRoleResourceRequest authRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isEmpty((Object)authRequest)) {
            throw new ApiException(RoleEnumCode.ROLE_PARAM_IS_NULL.transform());
        }
        ArrayList<SysRoleResource> roleResources = new ArrayList<SysRoleResource>(16);
        for (String resourceId : authRequest.getResourceId()) {
            roleResources.add(new SysRoleResource().setResourceId(resourceId).setRoleId(authRequest.getRoleId()));
        }
        this.sysRoleResourceService.remove((Wrapper)new QueryWrapper().eq((Object)"role_id", (Object)authRequest.getRoleId()));
        this.sysRoleResourceService.saveBatch(roleResources);
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u5220\u9664\u89d2\u8272", notes="\u6839\u636e\u89d2\u8272ID\u5220\u9664\u89d2\u8272 delete role by role id")
    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/delete"})
    public BaseResponse<SysRole> deleteEntity(@Valid @RequestBody SysRoleDeleteRequest deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isEmpty((Object)deleteRequest)) {
            throw new ApiException(RoleEnumCode.ROLE_ID_NONEXISTENT.transform());
        }
        SysRole role = (SysRole)((Object)this.sysRoleService.getById((Serializable)((Object)deleteRequest.getRoleId())));
        if (ObjectHelper.isEmpty((Object)((Object)role))) {
            throw new ApiException(RoleEnumCode.ROLE_ID_NONEXISTENT.transform());
        }
        this.sysUserRoleService.remove((Wrapper)new QueryWrapper().eq((Object)"role_id", (Object)role.getRoleId()));
        this.sysRoleResourceService.remove((Wrapper)new QueryWrapper().eq((Object)"role_id", (Object)role.getRoleId()));
        role.setStatus("1");
        this.sysRoleService.updateById((Object)role);
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u89d2\u8272ID\u5220\u9664\u89d2\u8272\uff08\u6279\u91cf\uff09", notes="\u6839\u636e\u89d2\u8272ID\u5220\u9664\u89d2\u8272\uff08\u6279\u91cf\uff09delete role by role ids")
    @Transactional(rollbackFor={Exception.class})
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<SysRole> deleteEntity(@Valid @RequestBody SysRoleDeleteBatchRequest deleteBatchRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isEmpty((Object)deleteBatchRequest)) {
            throw new ApiException(RoleEnumCode.ROLE_ID_NONEXISTENT.transform());
        }
        List roleIds = Arrays.stream(deleteBatchRequest.getRoleId()).collect(Collectors.toList());
        this.sysUserRoleService.remove((Wrapper)new QueryWrapper().in((Object)"role_id", roleIds));
        this.sysRoleResourceService.remove((Wrapper)new QueryWrapper().in((Object)"role_id", roleIds));
        List roles = this.sysRoleService.listByIds(roleIds);
        List sysRoles = roles.stream().map(role -> ((SysRole.SysRoleBuilder)SysRole.builder().roleId(role.getRoleId()).status("1")).build()).collect(Collectors.toList());
        this.sysRoleService.updateBatchById(sysRoles);
        return baseResponse;
    }

    private QueryWrapper<SysRole> createQuery(SysRoleParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringHelper.isEmpty((CharSequence)queryParam.getRoleName())) {
            queryWrapper.like((Object)"role_name", (Object)queryParam.getRoleName());
        }
        if (!StringHelper.isEmpty((CharSequence)queryParam.getRoleCode())) {
            queryWrapper.like((Object)"role_code", (Object)queryParam.getRoleCode());
        }
        if (StringHelper.isEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.in((Object)"status", Arrays.asList("0", "2"));
        } else if (!"1".equals(queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        }
        if (StringHelper.isNotBlank((CharSequence)queryParam.getOrderBy())) {
            if (!StringHelper.isNotBlank((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByAsc((Object)"role_sort");
        }
        return queryWrapper;
    }
}

