package com.testor.module.accident.model.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 事故上报对象 t_accident_report
 *
 * @author zhangyangfan@testor.com.cn
 * @date 2022-05-11 11:35:33
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_accident_report")
@ApiModel(value = "AccidentReport对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class AccidentReport extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;
    /**
     * 关联ID
     */
    @ApiModelProperty(value = "关联ID")
    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")
    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")
    @TableField("process_status")
    private String processStatus;
    /**
     * 上报单位
     */
    @ApiModelProperty(value = "上报单位")
    @TableField("report_unit")
    private String reportUnit;

    /**
     * 区域公司id
     */
    @ApiModelProperty(value = "区域公司id")
    @TableField("regional_company_id")
    private String regionalCompanyId;

    /**
     * 基层单位id
     */
    @ApiModelProperty(value = "基层单位id")
    @TableField("basic_unit_id")
    private String basicUnitId;

    /**
     * 事故时间
     */
    @ApiModelProperty(value = "事故时间")
    @TableField("accident_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date accidentTime;
    /**
     * 假日类型
     */
    @ApiModelProperty(value = "假日类型")
    @TableField("fake_type")
    private String fakeType;
    /**
     * 事故类型
     */
    @ApiModelProperty(value = "事故类型")
    @TableField("accident_type")
    private String accidentType;

    /**
     * 直接经济损失
     */
    @ApiModelProperty(value = "直接经济损失")
    @TableField("direct_economic_loss")
    private BigDecimal directEconomicLoss;

    /**
     * 间接经济损失
     */
    @ApiModelProperty(value = "间接经济损失")
    @TableField("indirect_economic_loss")
    private BigDecimal indirectEconomicLoss;

    /**
     * 合计经济损失
     */
    @ApiModelProperty(value = "合计经济损失")
    @TableField("total_economic_loss")
    private BigDecimal totalEconomicLoss;

    /**
     * 事故等级
     */
    @ApiModelProperty(value = "事故等级")
    @TableField("accident_level")
    private String accidentLevel;
    /**
     * 事故经过
     */
    @ApiModelProperty(value = "事故经过")
    @TableField("accident_passed")
    private String accidentPassed;
    /**
     * 事故原因
     */
    @ApiModelProperty(value = "事故原因")
    @TableField("accident_cause")
    private String accidentCause;
    /**
     * 改善措施
     */
    @ApiModelProperty(value = "改善措施")

    @TableField("improvements")
    private String improvements;
    /**
     * 附件
     */
    @ApiModelProperty(value = "附件")
    @TableField("attachment")
    private String attachment;

    /**
     * 消息通知类型
     */
    @ApiModelProperty(value = "消息通知类型")
    @TableField("receiver_type")
    private String receiverType;

    /**
     * 消息通知人
     */
    @ApiModelProperty(value = "消息通知人")
    @TableField("receiver_obj")
    private String receiverObj;

    /**
     * 驳回意见
     */
    @ApiModelProperty(value = "驳回意见")
    @TableField("reject_opinion")
    private String rejectOpinion;

    /**
     * 事故等级（国家）(字典:accident_level_country)
     */
    @ApiModelProperty(value = "事故等级（国家）(字典:accident_level_country)")
    @TableField("accident_level_country")
    private String accidentLevelCountry;

    /**
     * 事人员追责问责情况
     */
    @ApiModelProperty(value = "人员追责问责情况")
    @TableField("personnel_accountability_status")
    private String personnelAccountabilityStatus;

    /**
     * 损失工作日
     */
    @ApiModelProperty(value = "损失工作日")
    @TableField("lost_working_days")
    private String lostWorkingDays;

    /**
     * 涉及集团八大类风险(字典:group_risk)
     */
    @ApiModelProperty(value = "涉及集团八大类风险(字典:group_risk)")
    @TableField("group_risk")
    private String groupRisk;

    /**
     * 涉及危险作业类型(字典:dangerous_homework_category)
     */
    @ApiModelProperty(value = "涉及危险作业类型(字典:dangerous_homework_category)")
    @TableField("dangerous_homework_category")
    private String dangerousHomeworkCategory;

    /**
     * 受伤部位(字典:injured_area)
     */
    @ApiModelProperty(value = "受伤部位(字典:injured_area)")
    @TableField("injured_area")
    private String injuredArea;

    /**
     * 创建人部门id
     */
    @ApiModelProperty(value = "创建人部门id")
    @TableField("org_id")
    private String orgId;

    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String REPORT_UNIT = "report_unit";
    public static final String REGIONAL_COMPANY_ID = "regional_company_id";
    public static final String BASIC_UNIT_ID = "basic_unit_id";
    public static final String ACCIDENT_TIME = "accident_time";
    public static final String FAKE_TYPE = "fake_type";
    public static final String ACCIDENT_LEVEL = "accident_level";
    public static final String ACCIDENT_PASSED = "accident_passed";
    public static final String ACCIDENT_CAUSE = "accident_cause";
    public static final String IMPROVEMENTS = "improvements";
    public static final String ATTACHMENT = "attachment";
    public static final String ORG_ID = "org_id";


}
