package com.testor.module.contractor.common.model.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 承包商管理流程状态枚举
 */
@Getter
@AllArgsConstructor
public enum ContractorProcessStatus {

    /**
     * 待推送
     */
    PENDING_PUSH("0","待推送"),

    /**
     * 待提交
     */
    PENDING_SUBMISSION("1", "待提交"),

    /**
     * 审批中
     */
    UNDER_REVIEW("2", "审批中"),

    /**
     * 已通过
     */
    APPROVED("3", "已通过"),

    /**
     * 已驳回
     */
    REJECTED("4", "已驳回");

    private final String value; // 状态值
    private final String description; // 状态描述

    /**
     * 根据状态值获取枚举
     *
     * @param value 状态值
     * @return 对应的枚举，如果没有找到则返回 null
     */
    public static ContractorProcessStatus fromValue(String value) {
        for (ContractorProcessStatus status : values()) {
            if (status.value.equals(value)) {
                return status;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.value + " - " + this.description;
    }
}

