package com.testor.module.contractor.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.contractor.manage.dao.TContractorDailyPlanInspectResultHazardDao;
import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanInspectResultHazard;
import com.testor.module.contractor.manage.service.TContractorDailyPlanInspectResultHazardService;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 日常管理-每日工作计划-检查结果-隐患关联Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-30 15:43:18
 */
@Service
public class TContractorDailyPlanInspectResultHazardServiceImpl extends SuperServiceImpl<TContractorDailyPlanInspectResultHazardDao, TContractorDailyPlanInspectResultHazard> implements TContractorDailyPlanInspectResultHazardService
{
    @Autowired(required = false)
    private TContractorDailyPlanInspectResultHazardDao tContractorDailyPlanInspectResultHazardDao;

    @Override
    public List<String> getHazardIdsByInspectId(String inspectId) {
        List<TContractorDailyPlanInspectResultHazard> list = this.list(new LambdaQueryWrapper<>(TContractorDailyPlanInspectResultHazard.class).eq(TContractorDailyPlanInspectResultHazard::getInspectId, inspectId));
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().map(TContractorDailyPlanInspectResultHazard::getHazardId).collect(Collectors.toList());
    }

    @Override
    public List<String> getHazardIdsByInspectResultId(String inspectResultId) {
        List<TContractorDailyPlanInspectResultHazard> list = this.list(new LambdaQueryWrapper<>(TContractorDailyPlanInspectResultHazard.class).eq(TContractorDailyPlanInspectResultHazard::getInspectResultId, inspectResultId));
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().map(TContractorDailyPlanInspectResultHazard::getHazardId).collect(Collectors.toList());
    }
}
