package com.testor.module.contractor.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.module.contractor.manage.dao.TContractorPreparationEmergencyDao;
import com.testor.module.contractor.manage.model.domain.TContractorPreparation;
import com.testor.module.contractor.manage.model.domain.TContractorPreparationEmergency;
import com.testor.module.contractor.manage.model.dto.TContractorPreparationEmergencyAddParam;
import com.testor.module.contractor.manage.service.TContractorPreparationEmergencyService;
import com.testor.module.contractor.manage.service.TContractorPreparationService;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 开工准备-应急物资关系Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-24 13:20:08
 */
@Service
public class TContractorPreparationEmergencyServiceImpl extends SuperServiceImpl<TContractorPreparationEmergencyDao, TContractorPreparationEmergency> implements TContractorPreparationEmergencyService
{
    @Autowired(required = false)
    private TContractorPreparationEmergencyDao tContractorPreparationEmergencyDao;

    @Autowired
    private TContractorPreparationService tContractorPreparationService;

    @Override
    public void batchAddEntity(TContractorPreparationEmergencyAddParam addRequest) {
        // 1.新增前，先删除开工准备关联的应急物资数据
        String preparationId = addRequest.getPreparationId();
        QueryWrapper<TContractorPreparationEmergency> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(TContractorPreparationEmergency.PREPARATION_ID, preparationId);
        tContractorPreparationEmergencyDao.delete(queryWrapper);

        // 2.新增开工准备关联的应急物资数据
        TContractorPreparation tContractorPreparation = tContractorPreparationService.getById(preparationId);
        List<String> emergencyIds = addRequest.getEmergencyIds();
        List<TContractorPreparationEmergency> dataList =
                emergencyIds.stream().map(emergencyId -> {
                    TContractorPreparationEmergency tContractorPreparationEmergency = new TContractorPreparationEmergency();
                    tContractorPreparationEmergency.setPreparationId(preparationId);
                    tContractorPreparationEmergency.setEmergencyId(emergencyId);
                    tContractorPreparationEmergency.setContractorId(tContractorPreparation.getContractorId());
                    tContractorPreparationEmergency.setProjId(tContractorPreparation.getProjId());
                    tContractorPreparationEmergency.setBizId(tContractorPreparation.getBizId());
                    return tContractorPreparationEmergency;
                }).collect(Collectors.toList());
        this.saveBatch(dataList);
    }
}
