package com.testor.module.duty.service;


import com.testor.module.duty.model.domain.TSysDutyLog;
import com.testor.module.duty.model.dto.DutyLogDetail;
import com.testor.module.duty.model.dto.ReturnCreateLog;
import com.testor.module.duty.model.dto.TSysDutyLogParam;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 值班日志Service接口
 *
 * @author testor-framework
 * @date 2022-06-08 14:31:30
 */
public interface TSysDutyLogService extends SuperService<TSysDutyLog> {
    //创建值班日志
    BaseResponse<Object> addEntity(TSysDutyLogParam addRequest)throws Exception;
    //获取创建日志需要的信息
    BaseResponse<ReturnCreateLog> getCreateLogMsg(@RequestBody TSysDutyLogParam addRequest)throws Exception;
    //获取值班日志详情
    BaseResponse<DutyLogDetail> getByIds(String id);
    //创建日志 添加作业活动
    BaseResponse<Object> addEntityAndTask(TSysDutyLogParam addRequest) throws Exception;

    BaseResponse<Object> getGuardian();

    //获取值班期间的作业活动
    BaseResponse<Object> getActivityClass(TSysDutyLogParam addRequest)throws Exception;

    // 获取相关方及人员
    BaseResponse<Object> getInterestedPerson();
}
