package com.testor.module.environment.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 环保基本面管理对象 t_basic_environment_manage
 * 
 * @author testor-framework
 * @date 2022-09-16 13:37:50
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_basic_environment_manage")
@ApiModel(value = "TBasicEnvironmentManage对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TBasicEnvironmentManage extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 机构id 主键
 */
  @ApiModelProperty(value = "机构id 主键")

  @TableId("org_id")
  private String orgId;
/**
 * 企业所在地及市是否发布(三线一单)
 */
  @ApiModelProperty(value = "企业所在地及市是否发布(三线一单)")

  @TableField("location")
  private String location;
/**
 * 对照排查是否存在问题
 */
  @ApiModelProperty(value = "对照排查是否存在问题")

  @TableField("troubleshoot")
  private String troubleshoot;
/**
 * 企业是否处于敏感地带(三线一单)
 */
  @ApiModelProperty(value = "企业是否处于敏感地带(三线一单)")

  @TableField("sensitive_areas")
  private String sensitiveAreas;
/**
 * 环保验收情况
 */
  @ApiModelProperty(value = "环保验收情况")

  @TableField("check_case")
  private String checkCase;
/**
 * 排污许可证办理
 */
  @ApiModelProperty(value = "排污许可证办理")

  @TableField("licence")
  private String licence;
/**
 * 生态环境污染源
 */
  @ApiModelProperty(value = "生态环境污染源")

  @TableField("pollution")
  private String pollution;
/**
 * 生态环境风险点
 */
  @ApiModelProperty(value = "生态环境风险点")

  @TableField("risk_point")
  private String riskPoint;
/**
 * 取水方式
 */
  @ApiModelProperty(value = "取水方式")

  @TableField("intake")
  private String intake;
/**
 * 排水方式
 */
  @ApiModelProperty(value = "排水方式")

  @TableField("drain")
  private String drain;
/**
 * 烟(粉)尘(许可证排放大气污染物种类及排放量限值)
 */
  @ApiModelProperty(value = "烟(粉)尘(许可证排放大气污染物种类及排放量限值)")

  @TableField("dust")
  private String dust;
/**
 * 二氧化硫SO2(许可证排放大气污染物种类及排放量限值)
 */
  @ApiModelProperty(value = "二氧化硫SO2(许可证排放大气污染物种类及排放量限值)")

  @TableField("SO2")
  private String so2;
/**
 * 氮氧化物NOX(许可证排放大气污染物种类及排放量限值)
 */
  @ApiModelProperty(value = "氮氧化物NOX(许可证排放大气污染物种类及排放量限值)")

  @TableField("NOX")
  private String nox;
/**
 * 挥发性有机物排放量VOCs(许可证排放大气污染物种类及排放量限值)
 */
  @ApiModelProperty(value = "挥发性有机物排放量VOCs(许可证排放大气污染物种类及排放量限值)")

  @TableField("VOCs")
  private String vocs;
/**
 * 数量(套) (废气治理设施)
 */
  @ApiModelProperty(value = "数量(套) (废气治理设施)")

  @TableField("flue_count")
  private String flueCount;
/**
 * 处理能力(万立方米/年)(废气治理设施)
 */
  @ApiModelProperty(value = "处理能力(万立方米/年)(废气治理设施)")

  @TableField("flue_deal")
  private String flueDeal;
/**
 * 化学需氧量CODcr(许可证排放水污染物种类及排放量限值)
 */
  @ApiModelProperty(value = "化学需氧量CODcr(许可证排放水污染物种类及排放量限值)")

  @TableField("CODcr")
  private String codcr;
/**
 * 氨氮 (许可证排放水污染物种类及排放量限值)
 */
  @ApiModelProperty(value = "氨氮 (许可证排放水污染物种类及排放量限值)")

  @TableField("NH3_N")
  private String nh3N;
/**
 * 数量(套)(废水治理设施)
 */
  @ApiModelProperty(value = "数量(套)(废水治理设施)")

  @TableField("waste_count")
  private String wasteCount;
/**
 * 处理能力(废水治理设施)
 */
  @ApiModelProperty(value = "处理能力(废水治理设施)")

  @TableField("waste_deal")
  private String wasteDeal;
/**
 * 台数(燃煤锅炉(炉窑)数量及吨位)
 */
  @ApiModelProperty(value = "台数(燃煤锅炉(炉窑)数量及吨位)")

  @TableField("boiler_stage")
  private String boilerStage;
/**
 * 吨数(燃煤锅炉(炉窑)数量及吨位)
 */
  @ApiModelProperty(value = "吨数(燃煤锅炉(炉窑)数量及吨位)")

  @TableField("boiler_ton")
  private String boilerTon;
/**
 * 目前状态(燃煤锅炉(炉窑)数量及吨位)
 */
  @ApiModelProperty(value = "目前状态(燃煤锅炉(炉窑)数量及吨位)")

  @TableField("then_status")
  private String thenStatus;
/**
 * 台数(生物质锅炉(炉窑)数量及吨位)
 */
  @ApiModelProperty(value = "台数(生物质锅炉(炉窑)数量及吨位)")

  @TableField("biology_stage")
  private String biologyStage;
/**
 * 吨数(生物质锅炉(炉窑)数量及吨位)
 */
  @ApiModelProperty(value = "吨数(生物质锅炉(炉窑)数量及吨位)")

  @TableField("biology_ton")
  private String biologyTon;
/**
 * 台数(燃气锅炉(炉窑)数量及吨位)
 */
  @ApiModelProperty(value = "台数(燃气锅炉(炉窑)数量及吨位)")

  @TableField("fuel_stage")
  private String fuelStage;
/**
 * 吨数(燃气锅炉(炉窑)数量及吨位)
 */
  @ApiModelProperty(value = "吨数(燃气锅炉(炉窑)数量及吨位)")

  @TableField("fuel_ton")
  private String fuelTon;
/**
 * 主要负责人id
 */
  @ApiModelProperty(value = "主要负责人id")

  @TableField("major_id")
  private String majorId;
/**
 * 主要负责人姓名
 */
  @ApiModelProperty(value = "主要负责人姓名")

  @TableField("major_name")
  private String majorName;
/**
 * 主要负责人电话
 */
  @ApiModelProperty(value = "主要负责人电话")

  @TableField("major_phone")
  private String majorPhone;
/**
 * 分管领导id
 */
  @ApiModelProperty(value = "分管领导id")

  @TableField("branched_leader_id")
  private String branchedLeaderId;
/**
 * 分管领导姓名
 */
  @ApiModelProperty(value = "分管领导姓名")

  @TableField("branched_leader_name")
  private String branchedLeaderName;
/**
 * 分管领导电话
 */
  @ApiModelProperty(value = "分管领导电话")

  @TableField("branched_leader_phone")
  private String branchedLeaderPhone;
/**
 * 部门负责人id
 */
  @ApiModelProperty(value = "部门负责人id")

  @TableField("dept_person_id")
  private String deptPersonId;
/**
 * 部门负责人姓名
 */
  @ApiModelProperty(value = "部门负责人姓名")

  @TableField("dept_person_name")
  private String deptPersonName;
/**
 * 部门负责人电话
 */
  @ApiModelProperty(value = "部门负责人电话")

  @TableField("dept_person_phone")
  private String deptPersonPhone;
/**
 * 环保管理人员id
 */
  @ApiModelProperty(value = "环保管理人员id")

  @TableField("environ_person_id")
  private String environPersonId;
/**
 * 环保管理人员姓名
 */
  @ApiModelProperty(value = "环保管理人员姓名")

  @TableField("environ_person_name")
  private String environPersonName;
/**
 * 环保管理人员电话
 */
  @ApiModelProperty(value = "环保管理人员电话")

  @TableField("environ_person_phone")
  private String environPersonPhone;
/**
 * 机构名称
 */
  @ApiModelProperty(value = "机构名称")

  @TableField("org_name")
  private String orgName;

  @ApiModelProperty(value = "燃煤锅炉（炉窑） 1 有 0 无")
  @TableField(value = "ranmei")
  private String ranmei;

  @ApiModelProperty(value = "生物质锅炉（炉窑） 1 有 0 无")
  @TableField(value = "shenwu")
  private String shenwu;

  @ApiModelProperty(value = "燃气锅炉（炉窑） 1 有 0 无")
  @TableField(value = "ranqi")
  private String ranqi;

  @TableField(exist = false)
  private String updateName;

  @TableField(exist = false)
  private Integer serialNumber;


  public static final String ORG_ID ="org_id";
  public static final String LOCATION ="location";
  public static final String TROUBLESHOOT ="troubleshoot";
  public static final String SENSITIVE_AREAS ="sensitive_areas";
  public static final String CHECK_CASE ="check_case";
  public static final String LICENCE ="licence";
  public static final String POLLUTION ="pollution";
  public static final String RISK_POINT ="risk_point";
  public static final String INTAKE ="intake";
  public static final String DRAIN ="drain";
  public static final String DUST ="dust";
  public static final String SO2 ="SO2";
  public static final String NOX ="NOX";
  public static final String VOCS ="VOCs";
  public static final String FLUE_COUNT ="flue_count";
  public static final String FLUE_DEAL ="flue_deal";
  public static final String CODCR ="CODcr";
  public static final String NH3_N ="NH3_N";
  public static final String WASTE_COUNT ="waste_count";
  public static final String WASTE_DEAL ="waste_deal";
  public static final String BOILER_STAGE ="boiler_stage";
  public static final String BOILER_TON ="boiler_ton";
  public static final String THEN_STATUS ="then_status";
  public static final String BIOLOGY_STAGE ="biology_stage";
  public static final String BIOLOGY_TON ="biology_ton";
  public static final String FUEL_STAGE ="fuel_stage";
  public static final String FUEL_TON ="fuel_ton";
  public static final String MAJOR_ID ="major_id";
  public static final String MAJOR_NAME ="major_name";
  public static final String MAJOR_PHONE ="major_phone";
  public static final String BRANCHED_LEADER_ID ="branched_leader_id";
  public static final String BRANCHED_LEADER_NAME ="branched_leader_name";
  public static final String BRANCHED_LEADER_PHONE ="branched_leader_phone";
  public static final String DEPT_PERSON_ID ="dept_person_id";
  public static final String DEPT_PERSON_NAME ="dept_person_name";
  public static final String DEPT_PERSON_PHONE ="dept_person_phone";
  public static final String ENVIRON_PERSON_ID ="environ_person_id";
  public static final String ENVIRON_PERSON_NAME ="environ_person_name";
  public static final String ENVIRON_PERSON_PHONE ="environ_person_phone";
  public static final String ORG_NAME ="org_name";

  @JsonIgnore
  public String getId(){
  	return this.orgId;
  }
  @JsonIgnore
  public void setId(String orgId){
  	this.orgId = orgId;
  }

}
