package com.testor.module.hazard.model.template;

import com.alibaba.excel.annotation.ExcelProperty;
import com.testor.module.hazard.model.dto.HazardWorkPlanCheckDetailResult;
import lombok.Data;

import java.util.Map;

@Data
public class HazardWorkPlanStatisticsExportTemplate {

    @ExcelProperty("序号")
    private String number;

    @ExcelProperty("大区")
    private String regionName;

    @ExcelProperty("经营部")
    private String businessDeptName;

    @ExcelProperty("企业名称")
    private String currentOrgName;

    // ========== 合规率 ==========
    @ExcelProperty("全部作业合规率(%)")
    private Double allComplianceRate;

    @ExcelProperty("企业作业合规率(%)")
    private Double enterpriseComplianceRate;

    @ExcelProperty("相关方作业合规率(%)")
    private Double relatedPartyComplianceRate;

    @ExcelProperty("高度作业合规率(%)")
    private Double highComplianceRate;

    @ExcelProperty("较大作业合规率(%)")
    private Double majorComplianceRate;

    @ExcelProperty("一般作业合规率(%)")
    private Double normalComplianceRate;

    // ========== 抽查率 ==========
    @ExcelProperty("企业作业抽查率(%)")
    private Double enterpriseCheckRate;

    @ExcelProperty("相关方作业抽查率(%)")
    private Double relatedPartyCheckRate;

    @ExcelProperty("高度作业抽查率(%)")
    private Double highSpotCheckRate;

    @ExcelProperty("较大作业抽查率(%)")
    private Double majorSpotCheckRate;

    @ExcelProperty("一般作业抽查率(%)")
    private Double normalSpotCheckRate;

    // ========== 危险作业状态 ==========
    @ExcelProperty("五必须")
    private Integer fiveMust;

    @ExcelProperty("信息真实性")
    private Integer informationTruth;

    @ExcelProperty("违章作业")
    private Integer illegalOperation;

    @ExcelProperty("劳动组织")
    private Integer laborOrganization;

    @ExcelProperty("风险管理")
    private Integer riskManagement;

    @ExcelProperty("提级管理")
    private Integer escalationManagement;

    @ExcelProperty("变更管理")
    private Integer changeManagement;

    @ExcelProperty("其他")
    private Integer otherStatus;

    /**
     * 从 HazardWorkPlanCheckDetailResult 填充模板
     */
    public static HazardWorkPlanStatisticsExportTemplate fromResult(HazardWorkPlanCheckDetailResult result, int index) {
        HazardWorkPlanStatisticsExportTemplate template = new HazardWorkPlanStatisticsExportTemplate();

        template.setNumber(String.valueOf(index));
        template.setRegionName(result.getRegionName());
        template.setBusinessDeptName(result.getBusinessDeptName());
        template.setCurrentOrgName(result.getCurrentOrgName());

        Map<String, Double> compliance = result.getComplianceRateStats();
        template.setAllComplianceRate(compliance.getOrDefault("全部作业", 0D));
        template.setEnterpriseComplianceRate(compliance.getOrDefault("企业作业", 0D));
        template.setRelatedPartyComplianceRate(compliance.getOrDefault("相关方作业", 0D));
        template.setHighComplianceRate(compliance.getOrDefault("高度作业", 0D));
        template.setMajorComplianceRate(compliance.getOrDefault("较大作业", 0D));
        template.setNormalComplianceRate(compliance.getOrDefault("一般作业", 0D));

        Map<String, Double> spotCheck = result.getSpotCheckRateStats();
        template.setEnterpriseCheckRate(spotCheck.getOrDefault("企业作业", 0D));
        template.setRelatedPartyCheckRate(spotCheck.getOrDefault("相关方作业", 0D));
        template.setHighSpotCheckRate(spotCheck.getOrDefault("高度作业", 0D));
        template.setMajorSpotCheckRate(spotCheck.getOrDefault("较大作业", 0D));
        template.setNormalSpotCheckRate(spotCheck.getOrDefault("一般作业", 0D));

        Map<String, Integer> status = result.getWorkStatusStats();
        template.setFiveMust(status.getOrDefault("五必须", 0));
        template.setInformationTruth(status.getOrDefault("信息真实性", 0));
        template.setIllegalOperation(status.getOrDefault("违章作业", 0));
        template.setLaborOrganization(status.getOrDefault("劳动组织", 0));
        template.setRiskManagement(status.getOrDefault("风险管理", 0));
        template.setEscalationManagement(status.getOrDefault("提级管理", 0));
        template.setChangeManagement(status.getOrDefault("变更管理", 0));
        template.setOtherStatus(status.getOrDefault("其他", 0));

        return template;
    }
}
