package com.testor.module.iam.service;

import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.module.iam.model.domain.IamUserMapping;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

public interface SysUserService extends SuperService<SysUser> {

    /**
     * 获取有权限审批当前组织承包商数据的用户
     */
    public List<SysUser> getApprovalUsers(String orgId);

    /**
     * 获取有权限审批特定承包商记录的用户
     */
    public List<SysUser> getApprovalUsersForContractor(String contractorId, String orgId);

    /**
     * 验证用户是否有审批权限
     */
    public boolean validateApprovalPermission(String userId, String recordId, String orgId);

     /**
      * 验证用户是否有审批权限
      */
    public boolean validateApprovalPermissionForOrg(String userId, String orgId);

}
