package com.testor.module.partner.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.common.constant.StatusEnum;
import com.testor.module.partner.model.domain.TPartnerType;
import com.testor.module.partner.model.dto.TPartnerTypeDelParam;
import com.testor.module.partner.model.dto.TPartnerTypeParam;
import com.testor.module.partner.service.TPartnerTypeService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 相关方类型Controller
 *
 * @author testor-framework
 * @date 2022-06-01 14:19:22
 */
@RestController
@RequestMapping("/partner/partnerType")
@Api(value = "TPartnerType", tags = "相关方类型")
@Slf4j
public class TPartnerTypeController extends SuperController {
    @Autowired
    private TPartnerTypeService tPartnerTypeService;

    /* Generated Method*/
    @ApiOperation(value = "新增 相关方类型", notes = "Add TPartnerType")
    @PostMapping(value = "/add")
    public BaseResponse<TPartnerType> addEntity(@RequestBody TPartnerType addRequest) {
        BaseResponse<TPartnerType> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            String id = IdHelper.getId32bit();
            TPartnerType data = BeanHelper.beanToBean(addRequest, TPartnerType.class);
            data.setId(id);
            boolean result = tPartnerTypeService.save(data);
            if (result) {
                TPartnerType newEntity = new TPartnerType();
                newEntity.setId(id);
                baseResponse.setData(newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 所有相关方类型-下拉使用 ")
    @GetMapping(value = "/getAll")
    public BaseResponseList<TPartnerType> getAll(@RequestParam(required = false) String name) {
        BaseResponseList<TPartnerType> baseResponseList = new BaseResponseList<>();
        QueryWrapper<TPartnerType> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("id", "name");
        queryWrapper
                // 状态正常
                .eq("status", StatusEnum.USE.getCode())
        ;
        if (!StrUtil.isEmpty(name)) {
            queryWrapper.like("name", name);
        }
        List<TPartnerType> list = tPartnerTypeService.list(queryWrapper);
        baseResponseList.setData(list);
        return baseResponseList;
    }

    @ApiOperation(value = "获取 相关方类型 ", notes = "Get TPartnerType By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TPartnerType> getById(String id) {
        BaseResponse<TPartnerType> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            TPartnerType data = tPartnerTypeService.getById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @ApiOperation(value = "修改 相关方类型 ", notes = "Update TPartnerType By Id")
    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TPartnerType updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TPartnerType data = BeanHelper.beanToBean(updateRequest, TPartnerType.class);
            boolean result = tPartnerTypeService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "删除 相关方类型 ", notes = "delete TPartnerType By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TPartnerTypeDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TPartnerType data = new TPartnerType();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tPartnerTypeService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "批量删除相关方类型", notes = "delete TPartnerType by batch Id")
    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TPartnerTypeDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TPartnerType> tPartnerTypeList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TPartnerType data = new TPartnerType();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tPartnerTypeList.add(data);
            }
            boolean result = tPartnerTypeService.updateBatchById(tPartnerTypeList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 相关方类型 分页列表", notes = "List TPartnerType with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TPartnerType>> listEntity(TPartnerTypeParam param) {
        BaseResponse<BaseResponseList<TPartnerType>> baseResponse = new BaseResponse<>();
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TPartnerType> resultPage = new Page<>(page, limit);
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TPartnerType> queryWrapper = this.createQuery(param);
        Page<TPartnerType> resultList = tPartnerTypeService.page(resultPage, queryWrapper);
        BaseResponseList<TPartnerType> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "获取 相关方类型 列表", notes = "List TPartnerType all")
    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TPartnerType>> listAllEntity(TPartnerTypeParam param) {
        BaseResponse<BaseResponseList<TPartnerType>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TPartnerType> queryWrapper = this.createQuery(param).orderByAsc("create_date");
        List<TPartnerType> resultList = tPartnerTypeService.list(queryWrapper);
        BaseResponseList<TPartnerType> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TPartnerType> createQuery(TPartnerTypeParam queryParam) {
        QueryWrapper<TPartnerType> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getCode())) {
            queryWrapper.eq(TPartnerType.CODE, queryParam.getCode());
        }
        if (StringHelper.isNotEmpty(queryParam.getName())) {
            queryWrapper.like(TPartnerType.NAME, queryParam.getName());
        }
        if (StringHelper.isNotEmpty(queryParam.getDes())) {
            queryWrapper.eq(TPartnerType.DES, queryParam.getDes());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TPartnerType.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TPartnerType.STATUS, BizConstants.STATUS_DELETE);
        }

        return queryWrapper;
    }
}
