package com.testor.module.partner.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.module.partner.model.domain.TPartnerStaff;
import com.testor.module.partner.model.dto.TPartnerStaffDTO;
import com.testor.module.partner.model.dto.TPartnerStaffParam;
import com.testor.module.partner.model.excel.PartnerStaffReport;
import com.testor.module.partner.model.vo.OrganizationPersonnelVO;
import com.testor.module.partner.model.vo.PartnerStaffDetailVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 相关方机构员工Service接口
 *
 * @author testor-framework
 * @date 2022-06-01 14:18:06
 */
public interface TPartnerStaffService extends SuperService<TPartnerStaff> {
    /**
     * 编辑相关方人员
     *
     * @param partnerStaff
     * @return
     */
    @Transactional
    BaseResponse<TPartnerStaff> editPartnerStaff(TPartnerStaffDTO partnerStaff);

    /**
     * 获取 导出相关方人员的 数据源
     *
     * @return
     */
    List<PartnerStaffReport> exportPartnerStaff(HttpServletResponse response,TPartnerStaffParam param);

    /**
     * 导入 相关方机构
     *
     * @param file
     */
//    BaseResponse<String> importPartnerStaff(MultipartFile file);

//    void handleExcelData(List<PartnerStaffExp> partnerExpList);

    IPage<PartnerStaffDetailVO> listByPage(TPartnerStaffParam param);

    /**
     * 获取相关方人员详情
     *
     * @param id 相关方人员id
     * @return 相关方人员信息
     */
    PartnerStaffDetailVO getPartnerStaffDetail(String id);

    /**
     * 导入相关方人员信息
     *
     * @param file excel
     * @return
     */
    BaseResponse<String> addReportByExcel(MultipartFile file);

    /**
     * 获取组织机构及人员
     *
     * @return {@link Map}<{@link String}, {@link Object}>
     */
    Map<String, List<OrganizationPersonnelVO>> getOrganizationPersonnel();

    BaseResponse<String> importPersonnel(MultipartFile multipartFile) throws IOException;
}
