package com.testor.module.safe.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;


/**
 * 隐患上报台账对象 t_safe_hazard_org
 *
 * @author testor-framework
 * @date 2022-08-04 14:01:01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_hazard_org")
@ApiModel(value = "TSafeHazardOrg对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeHazardOrg extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 隐患单位（机构id0
     */
    @ApiModelProperty(value = "隐患单位（机构id）")

    @TableField("org_id")
    private String orgId;

    @ApiModelProperty(value = "隐患单位名称")
    @TableField(exist = false)
    private String orgName;
    /**
     * 隐患名称
     */
    @ApiModelProperty(value = "隐患名称")

    @TableField("name")
    private String name;
    /**
     * 发现形式
     */
    @ApiModelProperty(value = "发现形式")

    @TableField("check_type")
    private String checkType;
    /**
     * 关联对象
     */
    @ApiModelProperty(value = "关联对象")

    @TableField("manage_object")
    private String manageObject;
    /**
     * 关联设备
     */
    @ApiModelProperty(value = "关联设备")

    @TableField("equipment")
    private String equipment;
    /**
     * 隐患位置（当关联对象为 设备设施/空间场所 时有值）
     */
    @ApiModelProperty(value = "隐患位置（当关联对象为 设备设施/空间场所 时有值）")

    @TableField("location")
    private String location;
    /**
     * 照片（6张）
     */
    @ApiModelProperty(value = "照片（6张）")

    @TableField("images")
    private String images;
    /**
     * 是否转工单（0-否；1-是）
     */
    @ApiModelProperty(value = "是否转工单（0-否；1-是）")

    @TableField("work_order")
    private String workOrder;
    /**
     * 隐患分类
     */
    @ApiModelProperty(value = "隐患分类")

    @TableField("classify")
    private String classify;
    /**
     * 隐患级别
     */
    @ApiModelProperty(value = "隐患级别")

    @TableField("\"level\"")
    private String level;
    /**
     * 隐患类型
     */
    @ApiModelProperty(value = "隐患类型")

    @TableField("type")
    private String type;
    /**
     * 法规依据
     */
    @ApiModelProperty(value = "法规依据")

    @TableField("rule")
    private String rule;
    /**
     * 整改措施
     */
    @ApiModelProperty(value = "整改措施")
    @TableField("rectification")
    private String rectification;
    /**
     * 整改前防范措施
     */
    @ApiModelProperty(value = "整改前防范措施")

    @TableField("guard_against")
    private String guardAgainst;
    /**
     * 整改人
     */
    @ApiModelProperty(value = "整改人")
    @TableField("rectify_people")
    private String rectifyPeople;

    /**
     * 整改部门（整改人所属部门）
     */
    @ApiModelProperty(value = "整改部门（整改人所属部门）")
    @TableField("rectify_department")
    private String rectifyDepartment;


    /**
     * 验收部门（整改人所属部门）
     */
    @ApiModelProperty(value = "验收部门（验收人所属部门）")
    @TableField("acceptance_department")
    private String acceptanceDepartment;

    /**
     * 整改结束时间
     */
    @ApiModelProperty(value = "整改时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("rectify_date")
    private Date rectifyDate;
    /**
     * 验收人
     */
    @ApiModelProperty(value = "验收人")

    @TableField("acceptance")
    private String acceptance;

    @ApiModelProperty(value = "编号")
    @TableField("numbering")
    private String numbering;

    @ApiModelProperty(value = "-1、不存在接收对象，0：所有人，1-代表接收人、2代表组织结构")
    @TableField("receiver_type")
    private String receiverType;

    @ApiModelProperty(value = "接收对象：可为人，组织机构，根据receiver_type确定")
    @TableField("receiver_obj")
    private String receiverObj;

    @ApiModelProperty(value = "是否逾期（0-未逾期；1-逾期）")
    @TableField("overdue")
    private String overdue;


    @ApiModelProperty(value = "隐患问题原因（字典配置）")
    @TableField("hidden_danger_reason")
    private String hiddenDangerReason;

    @ApiModelProperty(value = "创建者用户名")
    @TableField("create_name")
    private String createName;

    @ApiModelProperty(value = "指派人")
    @TableField("assigner")
    private String assigner;

    @ApiModelProperty(value = "是否重复 0否 1是")
    @TableField("is_repeat")
    private String isRepeat;

    @ApiModelProperty(value = "是否计点 0否 1是")
    @TableField("is_count")
    private String isCount;

    @ApiModelProperty(value = "计点分数")
    @TableField("score")
    private String score;

    @ApiModelProperty(value = "实际整改开始时间")
    @TableField("rectify_start_date")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date rectifyStartDate;

    @ApiModelProperty(value = "计点明细 （计点字典值,分割）")
    @TableField("count_detail")
    private String countDetail;

    @ApiModelProperty(value = "责任人id")
    @TableField("liable_person")
    private String liablePerson;

    @ApiModelProperty(value = "整改状态 1符合 2不符合")
    @TableField("rectification_status")
    private String rectificationStatus;

    @ApiModelProperty(value = "整改验收意见  1符合 2不符合")
    @TableField("acceptance_opinion")
    private String acceptanceOpinion;

    @ApiModelProperty(value = "问题原因(字典类型 safe_hazard_org_problem_causes)")
    @TableField("problem_causes")
    private String problemCauses;

    @ApiModelProperty(value = "整改投入")
    @TableField("put_in")
    private String putIn;

    @ApiModelProperty(value = "验证材料")
    @TableField("material")
    private String material;

    @ApiModelProperty(value = "长效机制建设")
    @TableField("long_mechanism")
    private String longMechanism;

    @ApiModelProperty(value = "整改措施")
    @TableField("rectification_reform")
    private String rectificationReform;

    @ApiModelProperty(value = "验收时间")
    @TableField("acceptance_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date acceptanceTime;

    @ApiModelProperty(value = "整改后照片")
    @TableField("images_last")
    private String imagesLast;

    @ApiModelProperty(value = "指派时间")
    @TableField("assigned_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date assignedTime;

    @ApiModelProperty(value = "整改进度")
    @TableField("rectify_rate")
    private Integer rectifyRate;

    @ApiModelProperty(value = "进度情况")
    @TableField("progress")
    private String progress;
}
