package com.testor.module.safe.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * 巡检排查标准管理对象 t_safe_hazard_standard_type
 *
 * @author testor-framework
 * @date 2022-08-08 10:55:55
 */
@Data
@ApiModel(value = "TSafeHazardStandardTypeAllVOe对象", description = "")
public class TSafeHazardStandardTypeAllVO extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;

    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    @TableField("parent_id")
    private String parentId;




    /**
     * 标准分类名称
     */
    @ApiModelProperty(value = "标准分类名称")
    @TableField("name")
    private String name;

    /**
     * 具体分类项
     */
    @ApiModelProperty(value = "具体分类项")
    @TableField("category_item")
    private String categoryItem;

    /**
     * 是否系统内置（0-否；1-是）
     */
    @ApiModelProperty(value = "是否系统内置（0-否；1-是）")
    @TableField("built_in")
    private String builtIn;

    /**
     * 整改前后照片（0-非必填；1-必填）
     */
    @ApiModelProperty(value = "整改前后照片（0-非必填；1-必填）")
    @TableField("image")
    private String image;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序", example = "0")
    @TableField("sort")
    private Integer sort;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别", example = "0")
    @TableField("\"level\"")
    private Integer level;

    @ApiModelProperty(value = "整改前防范措施（0-非必填；1-必填）")
    @TableField("precautions")
    private String precautions;

    @ApiModelProperty(value = "子项")
    private List<TSafeHazardStandardTypeAllVO> typeAllVOList;

    @ApiModelProperty(value = "父级类型名称（若此条数据为系统类型时，此值为空,其它为此值为系统类型名称）")
    private String parentName;

    @ApiModelProperty(value = "父级类型名称（若此条数据为系统类型时，此值为空,其它为此值为系统类型编码）")
    private String parentCode;
}
