package com.testor.module.threeframework.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.module.notice.model.domain.TSysFile;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;


/**
 * 三同时管理附件对象 t_three_time_auxiliary
 *
 * @author testor-framework
 * @date 2022-09-15 17:16:21
 */
@Data
@ApiModel(value = "TThreeTimeAuxiliaryEditDTO 对象", description = "")
public class TThreeTimeAuxiliaryVO extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")
    private String processStatus;
    /**
     * 批复时间
     */
    @ApiModelProperty(value = "批复时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date replyDate;
    /**
     * 附件
     */
    @ApiModelProperty(value = "附件")
    private String accessory;
    /**
     * 项目进度（1-可研/2-初设/3-施工/4-验收/5-后评价）
     */
    @ApiModelProperty(value = "项目进度（1-可研/2-初设/3-施工/4-验收/5-后评价）")
    private String plan;
    /**
     * 附件类型（例：评价报告、附件及批复文件：safetyEvaluation），其他相关资料传入：rests
     */
    @ApiModelProperty(value = "附件类型（例：评价报告、附件及批复文件：safetyEvaluation），其他相关资料传入：rests")
    private String type;

    @ApiModelProperty(value = "附件")
    private List<TSysFile> tSysFileList;


}
