package com.testor.module.train.paper.model.dto;

import com.testor.module.train.exam.model.dto.TTrainTestQuestionsParam;
import com.testor.module.train.paper.model.domain.TTrainPaper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 试卷管理——安全教育培训 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-13 15:25:11
 */

@Data
@ApiModel(value = "TTrainPaper 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TTrainPaperParam extends TTrainPaper {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	private String dictValue;

	@ApiModelProperty(value = "多个试题")
	private List<TTrainTestQuestionsParam> tTrainTestQuestions;

}
