package com.testor.module.video.model.domain;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@Api(tags = "企业 场所树", value = "树形")
public class VideoChannelInfo implements Serializable {
    @ApiModelProperty(value = "id标识")
    private String id;
    @ApiModelProperty(value = "节点名称")
    private String name;
    @ApiModelProperty(value = "节点层级")
    private Integer level;
    @ApiModelProperty(value = "子节点")
    private Object childs;

    public VideoChannelInfo(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public VideoChannelInfo(String id, String name, Integer level, List<VideoChannelInfo> childs) {
        this.id = id;
        this.name = name;
        this.level = level;
        this.childs = childs;
    }

    public VideoChannelInfo(String id, String name, Integer level) {
        this.id = id;
        this.name = name;
        this.level = level;
    }

    public VideoChannelInfo() {
        super();
    }
}
