package com.testor.module.wf.utils;
 
import java.util.ArrayList;
import java.util.List;
 
/**
 * 转换工具类
 */
public class CastUtils {
 
    /**
     * 将obj转换为字符串列表
     * @param obj obj
     * @return 字符串列表
     */
    public static List<String> castObjToStringList(Object obj) {
        if (null == obj) {
            return null;
        }
 
        List<String> result = new ArrayList<>();
        if (obj instanceof List<?>) {
            for (Object o : (List<?>) obj) {
                result.add(o.toString());
            }
        } else if (obj instanceof String) {
            result.add(obj.toString());
        }
 
        return result;
    }
 
    /**
     * obj转list
     * @param obj obj
     * @param clazz clazz
     * @param <T> T
     * @return T
     */
    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        if (null == obj) {
            return null;
        }
 
        if (obj instanceof List<?>) {
            List<T> result = new ArrayList<>();
            for (Object o : (List<?>) obj) {
                result.add(clazz.cast(o));
            }
            return result;
        }
 
        return null;
    }
 
}