package com.testor.workflow.task.model.dto;

import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.workflow.service.dto.TaskCompleteParams;
import lombok.Data;

/**
 * TaskComplateParams
 *
 * @author Created by ivan on 2020/8/26 .
 * @version 1.0
 */
@Data
public class TaskCompleteParamsChild extends TaskCompleteParams {

  /** Complete User */
  private String processInstanceId;

  public boolean checkMiss() {

    if (StringHelper.isBlank(getUserId())) {
      return true;
    }
    if (StringHelper.isBlank(getOrgId())) {
      return true;
    }
    if (StringHelper.isBlank(getBizId())) {
      return true;
    }
    if (StringHelper.isBlank(getTaskId()) && StringHelper.isBlank(processInstanceId)) {
      return true;
    }

    return false;
  }

  public static String check(TaskCompleteParamsChild taskCompleteParams) {

    StringBuilder miss = new StringBuilder();
    if (ObjectHelper.isEmpty(taskCompleteParams)) {
      taskCompleteParams = new TaskCompleteParamsChild();
    }

    if (StringHelper.isBlank(taskCompleteParams.getUserId())) {
      miss.append(" userId ");
    }
    if (StringHelper.isBlank(taskCompleteParams.getOrgId())) {
      miss.append(" orgId ");
    }
    if (StringHelper.isBlank(taskCompleteParams.getBizId())) {
      miss.append(" bizId ");
    }
    if (StringHelper.isBlank(taskCompleteParams.getTaskId()) &&
            StringHelper.isBlank(taskCompleteParams.getProcessInstanceId())) {
      miss.append(" taskId or processInstanceId ");
    }
    return miss.toString();
  }
}
