/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.dict.type.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.dict.DictEnumCode;
import com.testor.biz.sys.dict.data.model.domain.SysDictData;
import com.testor.biz.sys.dict.data.service.SysDictDataService;
import com.testor.biz.sys.dict.type.model.domain.SysDictType;
import com.testor.biz.sys.dict.type.model.dto.SysDictTypeDelParam;
import com.testor.biz.sys.dict.type.model.dto.SysDictTypeParam;
import com.testor.biz.sys.dict.type.model.dto.SysDictTypeRequest;
import com.testor.biz.sys.dict.type.model.dto.SysDictTypeResponse;
import com.testor.biz.sys.dict.type.service.SysDictTypeService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.CollectionHelper;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="SysDictType", tags={"SysDictType \u5b57\u5178\u7c7b\u578b\u8868"})
@RequestMapping(value={"/dict/type"})
public class SysDictTypeController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(SysDictTypeController.class);
    @Autowired
    private SysDictTypeService sysDictTypeService;
    @Autowired
    private SysDictDataService sysDictDataService;

    @ApiOperation(value="\u65b0\u589e\u5b57\u5178\u7c7b\u578b", notes="\u65b0\u589e\u5b57\u5178\u7c7b\u578b Add SysDictType")
    @PostMapping(value={"/add"})
    public BaseResponse<SysDictTypeResponse> addEntity(@RequestBody SysDictTypeRequest addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)addRequest)) {
            int existed = this.sysDictTypeService.count((Wrapper)((QueryWrapper)new QueryWrapper().ne((Object)"status", (Object)"1")).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.eq((Object)"dict_name", (Object)addRequest.getDictName())).or()).eq((Object)"dict_type", (Object)addRequest.getDictType());
            }));
            if (0 < existed) {
                throw new ApiException(DictEnumCode.EXISTED.transform());
            }
            if (StringHelper.isBlank((CharSequence)addRequest.getCascaded())) {
                addRequest.setCascaded("0");
            }
            SysDictType sysDictType = (SysDictType)((Object)BeanHelper.beanToBean((Object)addRequest, SysDictType.class));
            sysDictType.setDictId(IdHelper.getId32bit());
            boolean result = this.sysDictTypeService.save((Object)sysDictType);
            baseResponse.setData((Object)SysDictTypeResponse.builder().dictId(sysDictType.getDictId()).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539\u5b57\u5178\u7c7b\u578b", notes="\u4fee\u6539\u5b57\u5178\u7c7b\u578b Update SysDictType by Id")
    @PutMapping(value={"/update"})
    public BaseResponse<SysDictTypeResponse> updateEntity(@RequestBody SysDictTypeRequest updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)updateRequest) && StringHelper.isNotEmpty((CharSequence)updateRequest.getDictId())) {
            List sysDictType = this.sysDictTypeService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().ne((Object)"status", (Object)"1")).ne((Object)"dict_id", (Object)updateRequest.getDictId())).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.eq((Object)"dict_name", (Object)updateRequest.getDictName())).or()).eq((Object)"dict_type", (Object)updateRequest.getDictType());
            }));
            if (CollectionHelper.isNotEmpty((Collection)sysDictType)) {
                throw new ApiException(DictEnumCode.EXISTED.transform());
            }
            SysDictType sysDict = (SysDictType)((Object)BeanHelper.beanToBean((Object)updateRequest, SysDictType.class));
            boolean result = this.sysDictTypeService.updateById((Object)sysDict);
            baseResponse.setData((Object)SysDictTypeResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664\u5b57\u5178\u7c7b\u578b", notes="\u5220\u9664\u5b57\u5178\u7c7b\u578b delete dict type by Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<SysDictTypeResponse> deleteEntity(@RequestBody SysDictTypeDelParam dictId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)dictId.getDictId())) {
            SysDictType data = new SysDictType();
            data.setDictId(dictId.getDictId());
            data.setStatus("1");
            List sysDictDataList = this.sysDictDataService.list((Wrapper)new QueryWrapper().lambda().eq(SysDictData::getDictId, (Object)data.getDictId()));
            this.sysDictDataService.updateBatchById(sysDictDataList.stream().peek(dictData -> dictData.setStatus("1")).collect(Collectors.toList()));
            boolean result = this.sysDictTypeService.updateById((Object)data);
            baseResponse.setData((Object)SysDictTypeResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5b57\u5178\u7c7b\u578b", notes="\u6279\u91cf\u5220\u9664\u5b57\u5178\u7c7b\u578b delete dict type by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<SysDictTypeResponse> deleteEntityBatch(@RequestBody SysDictTypeDelParam dictIds) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)dictIds) && !dictIds.getDictIds().isEmpty()) {
            List sysDictTypeList = dictIds.getDictIds().stream().map(sysDictTypeId -> ((SysDictType.SysDictTypeBuilder)SysDictType.builder().dictId((String)sysDictTypeId).status("1")).build()).collect(Collectors.toList());
            boolean result = this.sysDictTypeService.updateBatchById(sysDictTypeList);
            List sysDictDataList = this.sysDictDataService.list((Wrapper)new QueryWrapper().lambda().in(SysDictData::getDictId, (Collection)sysDictTypeList.stream().map(SysDictType::getDictId).collect(Collectors.toList())));
            this.sysDictDataService.updateBatchById(sysDictDataList.stream().peek(dictData -> dictData.setStatus("1")).collect(Collectors.toList()));
            baseResponse.setData((Object)SysDictTypeResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u7c7b\u578b\u8be6\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u5b57\u5178\u7c7b\u578b\u8be6\u7ec6\u4fe1\u606f Get SysDictType By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<SysDictType> getById(String dictId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)dictId)) {
            SysDictType data = (SysDictType)((Object)this.sysDictTypeService.getById((Serializable)((Object)dictId)));
            if (ObjectHelper.isEmpty((Object)((Object)data))) {
                throw new ApiException(DictEnumCode.UN_DICT_TYPE.transform());
            }
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u7c7b\u578b\u5217\u8868", notes="\u83b7\u53d6\u5b57\u5178\u7c7b\u578b\u5217\u8868 List SysDictType with Page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<SysDictType>> listEntity(SysDictTypeParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<SysDictType> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.sysDictTypeService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<SysDictType> createQuery(SysDictTypeParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getDictName())) {
            queryWrapper.like((Object)"dict_name", (Object)queryParam.getDictName());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getDictType())) {
            queryWrapper.like((Object)"dict_type", (Object)queryParam.getDictType());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getIsSys())) {
            queryWrapper.eq((Object)"is_sys", (Object)queryParam.getIsSys());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_date");
        }
        return queryWrapper;
    }
}

