/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper.cache;

import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class WeakMapCache<K, V>
implements Serializable {
    private static final long serialVersionUID = 4463726285707067361L;
    private final Map<K, V> weakMapCache;
    private final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.cacheLock.writeLock();

    public WeakMapCache() {
        this.weakMapCache = new WeakHashMap();
    }

    public WeakMapCache(Map<K, V> weakMapCache) {
        this.weakMapCache = weakMapCache;
    }

    public V get(K key) {
        V value;
        this.readLock.lock();
        try {
            value = this.weakMapCache.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        return value;
    }

    public V put(K key, V value) {
        this.writeLock.lock();
        try {
            this.weakMapCache.put(key, value);
        }
        finally {
            this.writeLock.unlock();
        }
        return value;
    }

    public V remove(K key) {
        this.writeLock.lock();
        try {
            V v = this.weakMapCache.remove(key);
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void empty() {
        this.writeLock.lock();
        try {
            this.weakMapCache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

